package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class MyCanvas extends Canvas implements CommandListener
{
    private HelloMidlet midlet;
    
    private Game game = new Game(this);
    
    public MyCanvas(HelloMidlet _midlet) 
    {
        midlet = _midlet;
        
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
        setCommandListener(this);
        
        if(game.initialize() == false)
        {
            return;
        }
        game.startGame();
    }
    
    protected void paint(Graphics g) 
    {
        game.draw(g);
    }
    
    protected void keyPressed(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        game.getHumanPlayer().gameActionPressed(gameAction);
    }
    
    protected void keyReleased(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        game.getHumanPlayer().gameActionReleased(gameAction);
    }
    
    protected void update()
    {   
        game.step();
    }
    
    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) 
        {
            case Command.EXIT:
            game.stopGame();
            midlet.quitApp();
            break;
        }
    }
}