package hello;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.lcdui.*;

public class NumberCanvas   extends Canvas implements CommandListener 
{
    private BluetoothConnection[] btConnections;
    private BluetoothExample  midlet;
    private boolean isServer;
    private Vector consoleStrings = new Vector();
    private static final int numRowsInConsole = 6;
    
    public  NumberCanvas(BluetoothConnection[] btConns,
    BluetoothExample _midlet,
    boolean _isServer ) 
    {
        midlet   = _midlet;
        isServer = _isServer;
        
        btConnections = btConns;
        
        for( int i=0; i<btConnections.length; i++ ) {
            ReceiveThread rt = new ReceiveThread(i);
            rt.start();
        }
        
        addCommand( new Command( "Wyjdz", Command.CANCEL, 1 ) );
        setCommandListener( this );
    }
    
    public BluetoothConnection getConnection(int index) {
        return btConnections[index];
    }
    
    public void commandAction( Command c, Displayable s ) {
        if( c.getCommandType() == Command.CANCEL ) {
            close();
            midlet.startUI();
        }
    }
    
    private synchronized void close() {
        for( int i=0; i<btConnections.length; i++ ) {
            btConnections[i].close();
        }
    }
    
    public void updateRemoteChar( int index, int c) {
        if(true == isServer) {
            for( int i=0; i<btConnections.length; i++ ) {
                if(i != index)
                    sendIntegerToPeer(i,(int)c);
            }
        }
        Log("Przeslano do mnie: " + c);
    }
    
    private void sendIntegerToPeer(int peerIndex, int c) 
    {
        BluetoothConnection connection = btConnections[peerIndex];
        try {
            connection.writeInt(c);
        }
        catch(IOException e) {
            connection.close();
        }
    }
    
    class ReceiveThread extends Thread 
    {
        private int index;
        
        public ReceiveThread(int i) {
            index = i;
        }
        
        public void run() {
            int inp;
            
            while( true ) {
                try {
                    inp = getConnection(index).readInt();
                } catch( IOException e ) {
                    getConnection(index).close();
                    return;
                }
                
                if( inp == -1 ) {
                    getConnection(index).close();
                    return;
                }
                updateRemoteChar( index, inp);
            }
        }
    }
    
    public void paint( Graphics g ) {
        drawConsole(g);
    }
    
    public void keyPressed( int keyCode ) {
        byte  c;
        switch( keyCode ) {
            case KEY_NUM0:  c = 0;    break;
            case KEY_NUM1:  c = 1;    break;
            case KEY_NUM2:  c = 2;    break;
            case KEY_NUM3:  c = 3;    break;
            case KEY_NUM4:  c = 4;    break;
            case KEY_NUM5:  c = 5;    break;
            case KEY_NUM6:  c = 6;    break;
            case KEY_NUM7:  c = 7;    break;
            case KEY_NUM8:  c = 8;    break;
            case KEY_NUM9:  c = 9;    break;
            default:                  return;
        }
        
        
        if(true == isServer) {
            for( int i=0; i<btConnections.length; i++ )
                sendIntegerToPeer(i,c );
        } else {
            sendIntegerToPeer(0,c);
        }
        
        Log("Nacisnalem klawisz: " + c);
    }
    
    private void Log(String message) {
        consoleStrings.addElement(message);
        while(consoleStrings.size() > numRowsInConsole)
            consoleStrings.removeElementAt(0);
        repaint();
        serviceRepaints();
    }
    
    private void drawConsole(Graphics g) {
        Font f;
        int y, h;
        
        g.setColor( 255, 255, 255 );
        g.fillRect( 0, 0, getWidth(), getHeight() );
        g.setColor( 0, 0, 255 );
        
        f = Font.getFont( Font.FACE_MONOSPACE, Font.STYLE_BOLD, Font.SIZE_MEDIUM );
        g.setFont(f);
        
        y=0; h=16;
        
        for(int i=0 ; i<consoleStrings.size() ; i++) {
            g.drawString((String)consoleStrings.elementAt(i), 0, y, Graphics.TOP | Graphics.LEFT );
            y += h;
        }
    }
}
