package hello;

import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;
import java.util.*;
import javax.bluetooth.*;

public class BluetoothConnection {
    private StreamConnection streamConnection;
    private InputStream inputStream;
    private OutputStream outputStream;
    
    private String localName;    
    private String remoteName;
    private String url;
    
    
    public BluetoothConnection(StreamConnection con, String ln, String rn) throws IOException 
    {    
        localName = ln;
        remoteName = rn;
        url = "";     
        streamConnection = con;
        
        openStreams();
    }
    
    public BluetoothConnection(String urlStrings, String ln, String rn) throws IOException 
    {
        localName = ln;
        remoteName = rn;
        url = urlStrings;
        
        connect();
    }
    
    private void connect() throws IOException {
        
        streamConnection = (StreamConnection) Connector.open( url );
        
        openStreams();
    }
    
    
    private void openStreams() throws IOException {
        inputStream = streamConnection.openInputStream();
        outputStream = streamConnection.openOutputStream();
    }
    
    synchronized public void close() {
        try {
            outputStream.close();
        } catch(IOException e) {}
        
        try {
            inputStream.close();
        } catch(IOException e) {}
        
        try {
            if(streamConnection != null) {
                streamConnection.close();
                streamConnection = null;
            }
        } catch( IOException e ) {}
    }
    
    public void writeInt(int c) throws IOException
    {
        outputStream.write((int)c);
        outputStream.flush();
    }
    
    public int readInt() throws IOException
    {
        return inputStream.read();
    }
    
    public String getLocalName()  {   return localName;       }    
    public String getRemoteName() {   return remoteName;      }
    
    protected void setRemoteName(String rn) { remoteName=rn;  }
    
    public boolean isClosed() { return streamConnection==null; }
}
