package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;
import java.util.*;

public class MyCanvas extends Canvas {
    
    private static int numberOfTrees = 80;
    private static float forestSize = 15;
    
    private Graphics3D      iG3D;
    private Camera          iCamera;
    private float           iAngle = 0.0f;
    private World           world;
    private Image           iImage;
    private Mesh            mesh;
    private Texture2D       floorTexture;
    
    short[] vertices = {20, -1,-20, -20, -1,-20, 20, -1, 20, -20, -1, 20 };
    short[] uv = { 0,0,  8,0,  0,8,  8,8};
    
    
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private void init() throws Exception  
    {
        addCommand(new Command("Exit", Command.EXIT, 1));
        
        iG3D = Graphics3D.getInstance();
        world = new World();
        
        iCamera = new Camera();
        iCamera.setPerspective( 60.0f,
        (float)getWidth()/ (float)getHeight(),
        1.0f,
        1000.0f);
        
        world.addChild(iCamera);                                   
        
        Image tree = Image.createImage("/tree.png");
        Image2D tree2D = new Image2D( Image2D.RGBA, tree);
        Image floorImg = Image.createImage("/floor.png");
        Image2D floorImg2D = new Image2D( Image2D.RGBA, floorImg);
        floorTexture = new Texture2D(floorImg2D);
        
        Appearance spriteAppearance = new Appearance();
        CompositingMode compositing = new CompositingMode();
        compositing.setBlending(CompositingMode.ALPHA);
        spriteAppearance.setCompositingMode(compositing);
        
        Random rnd = new Random();
        for(int i=0;i<80;i++)
        {
            float x = (rnd.nextFloat()-0.5f)*forestSize;
            float y = (rnd.nextFloat()-0.5f)*forestSize;
            
            Sprite3D sprite = new Sprite3D(true,tree2D,spriteAppearance);
            sprite.setTranslation(x,-0.5f,y);
            world.addChild(sprite);
        }
        
        world.setActiveCamera(iCamera);
        
        VertexArray _vertices = new VertexArray(vertices.length/3,3,2);
        _vertices.set(0,vertices.length/3,vertices);
        VertexBuffer vb = new VertexBuffer();
        vb.setPositions(_vertices,1.f,null);        
        
        VertexArray _uvs = new VertexArray(uv.length/2,2,2);
        _uvs.set(0,uv.length/2,uv);
        vb.setPositions(_vertices,1.f,null);        
        vb.setTexCoords(0,_uvs,1.f,null);
        
        TriangleStripArray ib = new TriangleStripArray(0, new int[] {4});
        
        Appearance appearance = new Appearance();
        appearance.setTexture(0,floorTexture);
        PolygonMode p = new PolygonMode();
        p.setPerspectiveCorrectionEnable(true);
        appearance.setPolygonMode(p);
        
        mesh = new Mesh(vb,ib,appearance);
        world.addChild(mesh);
    }
    
    protected void paint(Graphics g) 
    {
        iG3D.bindTarget(g, true,Graphics3D.DITHER |
        Graphics3D.TRUE_COLOR);
        
        Transform transform = new Transform();
        transform.postRotate(iAngle, 0.0f, 1.0f, 0.0f);
        transform.postTranslate(0.0f, 2.0f, 12.0f);
        
        iAngle += 1.0f;                                
        
        iCamera.setTransform(transform);
        iG3D.render(world);
        iG3D.releaseTarget();
    }
}
