package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;
import java.util.*;

public class MyCanvas extends Canvas {
    
    private Graphics3D      g3d;
    private World           world;    
    
    private int time = 0;        
    Timer iTimer = new Timer();
    
    public MyCanvas() {
        
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }       
    }
    
    private void init() throws Exception  
    {
        
        addCommand(new Command("Koniec", Command.EXIT, 1));
        
        g3d = Graphics3D.getInstance();
        Object3D[] roots = Loader.load("/anim_scene.m3g");      
        world = (World)roots[0];
        
        iTimer.schedule( new MyTimerTask(), 0, 1 );
    }
    
    protected void paint(Graphics g) 
    {    
        time+=10;
        world.animate(time%3000);
        
        g3d.bindTarget(g);
        g3d.render(world);
        g3d.releaseTarget();
    }
    
    class MyTimerTask extends TimerTask {
        public void run() {
            repaint();
        }
    }
}
