package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class MyCanvas extends Canvas {   
    
    private World  world;    
    
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            addCommand(new Command("Koniec", Command.EXIT, 1));
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }       
    }
    private void init() 
    {           
        world = new World();
        
        Camera activeCamera = new Camera();
        activeCamera.setPerspective(30.0f,
              (float)getWidth()/(float)getHeight(),
              1.0f,1000.0f );
        world.addChild(activeCamera);                                 
        world.setActiveCamera(activeCamera);        
        activeCamera.setTranslation(0,0,10);
        
        Mesh box = createBoxMesh();   
        world.addChild(box);
    }
    
    protected void paint(Graphics g) 
    {    
        Graphics3D g3d = Graphics3D.getInstance();
        g3d.bindTarget(g);
        g3d.render(world);
        g3d.releaseTarget();
    }
    
    Mesh createBoxMesh()
    {
        short[] vertices = new short[]{ -1,-1, 1,  1,-1, 1, 
                                        -1, 1, 1,  1,1, 1,
                                        -1,-1,-1,  1,-1,-1,
                                        -1, 1,-1,  1,1,-1 };
        
        int[] indices = new int[] {0,1,2,3,7,1,5,4,7,6,2,4,0,1 };
        
        VertexBuffer vb = new VertexBuffer();
        VertexArray vert = new VertexArray(vertices.length/3,3,2);
        vert.set(0,vertices.length/3,vertices);
        vb.setPositions(vert,1.f,null);
        vb.setDefaultColor(0x00ffee70);
        
        TriangleStripArray ib = 
        new TriangleStripArray(indices, new int[] {indices.length});
        
        return new Mesh(vb,ib,new Appearance());
    }   
}
