package hello;

import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.*;

public class Terrain {
    
    private VertexBuffer    vb;
    private IndexBuffer     ib;
    private Appearance      appearance;
    
    int sizeX;
    int sizeY;
    int[] indicesTemp;
    int   currIdxTemp;
    
    public Terrain() {}
    
    public void draw(Graphics3D iG3D, Transform transform)
    {       
        iG3D.render(vb, ib, appearance, transform);        
    }
    
    public void create(String diffuseMap, String heightMap) {
        
        int[] heights;
        
        try
        {
            Image heightmap = Image.createImage(heightMap);
            
            sizeX = heightmap.getWidth();
            sizeY = heightmap.getHeight();
            
            heights = new int[sizeX*sizeY];
            
            heightmap.getRGB(heights,0, sizeX,0,0,sizeX,sizeY);
            
            Image2D image2D = new Image2D( Image2D.RGB, heightmap );
            
            Image diffImage = Image.createImage(diffuseMap);            
            Image2D diffImage2D = new Image2D( Image2D.RGB, diffImage);
            Texture2D diffuseTexture = new Texture2D(diffImage2D);
            diffuseTexture.setFiltering(Texture2D.FILTER_LINEAR,
            Texture2D.FILTER_LINEAR);
            diffuseTexture.setBlending(Texture2D.FUNC_DECAL);
            
            short[] vertices = new short[sizeX*sizeY*3];
            for(int j=0 ; j<sizeY ; j++)
            {
                for(int i=0 ; i<sizeX ; i++)
                {
                    int index = j*sizeX + i;
                    vertices[index*3] = (short)(i-16);
                    vertices[index*3+1] = (short)((heights[index]&0xff)/30);
                    vertices[index*3+2] = (short)(j-16);                                                           
                }
            }
            
            VertexArray vertArray = new VertexArray(vertices.length/3, 3, 2);
            vertArray.set(0, vertices.length/3, vertices);
            
            short[] tex = new short[sizeX*sizeY*2];
            for(int j=0 ; j<sizeY ; j++)
            {
                for(int i=0 ; i<sizeX ; i++)
                {
                    int index = j*sizeX + i;
                    tex[index*2]   = (short)i;
                    tex[index*2+1] = (short)j;                    
                }
            }
            
            VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
            texArray.set(0, tex.length/2, tex);
            
            vb = new VertexBuffer();
            vb.setPositions(vertArray, 1.0f, null);
            vb.setTexCoords(0, texArray, 1.f/32.0f, null);
            
            appearance = new Appearance();            
            appearance.setTexture(0,diffuseTexture/*texture*/);
            
            Fog fog = new Fog();
            fog.setLinear(20,45);
            fog.setColor(0x4070f0);
            appearance.setFog(fog);
            
            int[] indices = createTerrainTriangleStrip(sizeX, sizeY);
            ib = new TriangleStripArray( indices, new int[] {indices.length});
            
        }
        catch(IOException e)
        {}        
    }
    
    private void addIndex(int vertexIndex)
    {    
        indicesTemp[currIdxTemp++] = vertexIndex;
    }
    
    public boolean isEven(int rowIndex)
    {
        return (rowIndex&1) == 0;
    }
    
    private int calculateStartIndex(int numCollumns, int rowIndex)
    {
        if(isEven(rowIndex)==true)
            return (rowIndex*numCollumns);
        else
            return (rowIndex+2)*numCollumns-1;
    }
    
    private int calculateTurnIndex(int numCollumns, int rowIndex)
    {
        if(isEven(rowIndex)==false)
            return (rowIndex*numCollumns);
        else
            return (rowIndex+2)*numCollumns-1;
    }
    
    private void addEvenRow(int numCollumns, int rowIndex)
    {
        int startIndex = calculateStartIndex(numCollumns, rowIndex);
        for(int i=0;i<numCollumns;i++)
        {
            addIndex(startIndex);
            addIndex(startIndex+numCollumns);
            ++startIndex;
        }        
    }
    
    private void addOddRow(int numCollumns, int rowIndex)
    {
        int startIndex = calculateStartIndex(numCollumns, rowIndex);
        for(int i=0;i<numCollumns;i++)
        {
            addIndex(startIndex);
            addIndex(startIndex-numCollumns);
            --startIndex;
        }
    }    
    
    private void addTurn(int numCollumns, int rowIndex)
    {
        int degeneratedIndex = calculateTurnIndex(numCollumns, rowIndex);
        addIndex(degeneratedIndex);
        addIndex(degeneratedIndex);
    }
    
    public int[] createTerrainTriangleStrip(int numCollumns, int numRows)
    {
        currIdxTemp = 0;
        indicesTemp = new int[(numCollumns*2*(numRows-1)) + (numRows-2)*2];
        
        for(int j=0;j<numRows-1;j++)
        {
            if(isEven(j) == true)
                addEvenRow(numCollumns, j);
            else
                addOddRow(numCollumns, j);
            
            if(j<(numRows-2))   
                addTurn(numCollumns, j);
        }        
        return indicesTemp;
    }
}
