package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class MyCanvas extends Canvas {
    
    private Graphics3D      iG3D;
    private Camera          iCamera;
    private Light           iLight;
    private float           iAngle = 0.0f;
    private Transform       iTransform = new Transform();
    private Background      iBackground = new Background();
    private VertexBuffer    iVb;
    private IndexBuffer     iIb;
    private Appearance      iAppearance;
    private Material        iMaterial = new Material();
    private Image           iImage;
    
    private Terrain terrain;
    
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private void init() throws Exception  
    {
        addCommand(new Command("Exit", Command.EXIT, 1));
        
        terrain = new Terrain();
        terrain.create("/diffuse.png", "/texture.png");
        
        iG3D = Graphics3D.getInstance();
        
        iCamera = new Camera();
        iCamera.setPerspective( 60.0f,
              (float)getWidth()/ (float)getHeight(),
              1.0f,
              1000.0f );
        
        iLight = new Light();
        iLight.setColor(0xffffff);
        iLight.setIntensity(1.25f);
        
        iBackground.setColor(0x4070f0);                                            
    }
    
    protected void paint(Graphics g) 
    {        
        iG3D.bindTarget(g, true,
              Graphics3D.DITHER |
              Graphics3D.TRUE_COLOR);
        
        iG3D.clear(iBackground);
        
        Transform transform = new Transform();
        iG3D.resetLights();
        iG3D.addLight(iLight, transform);
        
        transform.postRotate(iAngle, 0.0f, 1.0f, 0.0f);
        transform.postTranslate(0.0f, 20.0f, 30.0f);
        transform.postRotate(-20, 1.0f, 0.0f, 0.0f);
        iG3D.setCamera(iCamera, transform);
        
        iAngle += 1.0f;
        iTransform.setIdentity();
        
        terrain.draw(iG3D, iTransform);
        
        iG3D.releaseTarget();        
    }
}
