package mypackage;

import javax.microedition.lcdui.*;
import java.util.*;
import java.lang.Math.*;

public class Raycaster extends Canvas {
    
    public static int screenHeight = 200;    // rozdzielczosc ekranu y
    public static int screenWidth  = 180;    // rozdzielczosc ekranu x
    public static int screenHalfHeight = 50;    // rozdzielczosc ekranu y
    public static final int maxDistance = 40;
    
    private Player player;
    
    private int halfViewAngle = 45;
    
    private void initialize() {
        player = new Player(this);
        player.setPos(1.5f,3.50f);
    }
    
    public int getMapPoint(int x, int y) {
        return worldMap[x][y];
    }
    
    private  int worldMap[][] = new int[][] {
        {4,1,1,1,1,1,1},
        {4,0,0,0,0,0,2},
        {4,0,1,0,0,0,2},
        {4,0,1,0,0,0,2},
        {4,0,0,0,1,1,2},
        {4,0,0,0,0,0,2},
    {4,3,3,3,3,3,3}};
    
    private int arrX[] = new int[] { 1,-1,-1, 1 };
    private int arrY[] = new int[] { 1, 1,-1,-1 };
    
    public Raycaster() {
	initialize();
    }
    
    public void paint(Graphics g) 
    {
	int playerDirection = player.getAngle()%360;
	if(playerDirection<0) 
	    playerDirection+=360;
	
	screenWidth = g.getClipWidth();
	screenHeight = g.getClipHeight();
	screenHalfHeight = screenHeight/2;
	
	g.fillRect(0,0,screenWidth,screenHeight);
	
	Render(g,playerDirection, player.getPosX(), player.getPosY());
    }
    
    private double Cos(double angle) { return Math.cos(Math.toRadians(angle)); }
    private double Sin(double angle) { return Math.sin(Math.toRadians(angle)); }
    
    public void Render(Graphics g, int playerDirection, double playerX, double playerY) {
	
	double playerDirX = Cos(playerDirection);
	double playerDirY = Sin(playerDirection);
	
	double playerPerpDirX = -playerDirY;
	double playerPerpDirY =  playerDirX;
	
	double deltaOffset=1.0/screenWidth;
	int x=0;
	// for each screen vertical line
	for(double offset = -1 ; offset < 1 ; offset += deltaOffset)
	{
	    int ceilPosX = (int)playerX;
	    int ceilPosY = (int)playerY;
	    double a = 1.0 - (playerX - ceilPosX);
	    double b = 1.0 - (playerY - ceilPosY);
	    
	    double rx = playerDirX + playerPerpDirX * offset;
	    double ry = playerDirY + playerPerpDirY * offset;		 
	    
	    double stepX,stepY;
	    stepX = stepY = -1;
	    
	    if(rx>0) 
		stepX = 1;
	    else
		a = (playerX - ceilPosX);
	    
	    if(ry>0) 
		stepY = 1;
	    else
		b = (playerY - ceilPosY);
	    
	    double lengthR = Math.sqrt(rx*rx + ry*ry);
	    
	    double dl = Math.abs(lengthR /ry);
	    double dk = Math.abs(lengthR /rx);
	    
	    double k = a * dk;
	    double l = b * dl;
	    
	    boolean hit = false;    // was there a wall hit?
	    int leftSideHit = 1;    // was a NS or a EW wall hit?                
	    
	    
	    double distance = 0.f;
	    
	    while(false == hit) {
		if(k>l) {
		    ceilPosY += stepY;
		    if(0 != worldMap[ceilPosX][ceilPosY]) {
			hit = true;
			distance = l;
			leftSideHit = 1;
		    } else {
			l += dl;
		    }
		} else {
		    ceilPosX += stepX;
		    if(0 != worldMap[ceilPosX][ceilPosY]) {
			hit = true;
			distance = k;
			leftSideHit = 2;//2 to daje cieniowanie
		    } else {
			k += dk;
		    }
		}
	    }                
	    
	    if(leftSideHit == 1)
		g.setColor(100,100,100);
	    else
		g.setColor(255,255,255);
	    
	    
	    distance = distance / lengthR;
	    distance = 70/distance;
	    
	    g.drawLine(x,screenHalfHeight - (int)distance, 
	    x,screenHalfHeight + (int)distance);
	    x++;
	    //x+=32;
	}            	
    }
    
public void keyPressed(int keyCode) {
	int action = getGameAction(keyCode);
	switch(action) {
	    case Canvas.LEFT:
	    player.RotateLeft();
	    break;
	    case Canvas.RIGHT:
	    player.RotateRight();
	    break;
	    case Canvas.UP:
	    player.MoveForward();
	    break;
	    case Canvas.DOWN:
	    player.MoveBackward();
	    break;
	}
	repaint();
	serviceRepaints();
    }
    
    
    
}
