package mypackage;

/**
 *
 * @author Administrator
 */
public class Player {
    private Raycaster r;
    
    private float posX;
    private float posY;
    private int angle = 90;
    
    /** Creates a new instance of Player */
    public Player(Raycaster _r) {
        r = _r;
    }
    
    private int getSpeed() {
        return 1;
    }
    
    public void setPos(float x,float y) {
        posX = x;
        posY = y;
    }

    public float getPosX()    { return posX; }
    public float getPosY()    { return posY; }

    public int getAngle() { return angle; }
    public void setAngle(int _angle) { angle = _angle; }
    
    public void MoveForward() 
    {
        float newPosX = posX + 0.4f * (float)Math.cos(Math.toRadians((double)angle));
        float newPosY = posY + 0.4f * (float)Math.sin(Math.toRadians((double)angle));
                
        if(r.getMapPoint( (int)newPosX,(int)posY) == 0)
            posX = newPosX;
        if(r.getMapPoint( (int)posX,(int)newPosY) == 0)
            posY = newPosY;
    }
    
    public void MoveBackward() 
    {
        float newPosX = posX - 0.4f * (float)Math.cos(Math.toRadians((double)angle));
        float newPosY = posY - 0.4f * (float)Math.sin(Math.toRadians((double)angle));
        
        if(r.getMapPoint( (int)newPosX,(int)posY) == 0)
            posX = newPosX;
        if(r.getMapPoint( (int)posX,(int)newPosY) == 0)
            posY = newPosY;
    }
    
    public void RotateLeft() {
        angle-=5;
    }
    
    public void RotateRight() {
        angle+=5;
    }   
}
