package hello;

import javax.microedition.lcdui.*;

public class MyCanvas extends Canvas implements CommandListener{
   
   
    HelloMidlet midlet;

    public MyCanvas(HelloMidlet _midlet) {
	midlet = _midlet;
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
	setCommandListener(this);
    }
    
   
    protected void paint(Graphics g) 
    {
	int screenWidth  = getWidth();
	int screenHeight = getHeight();

	
	g.fillRect(0,0,screenWidth, screenHeight);
	
	g.setColor(255,0,100);
	g.drawRect(0,0,screenWidth/4, screenHeight/4);

	g.setColor(100,0,255);	
	g.drawArc(0,screenHeight/4,screenWidth/4,screenHeight/4,0,360);

	g.setColor(60,255,60);	
	g.drawLine(0,screenHeight/2,screenWidth/4,3*screenHeight/4);
	g.drawLine(screenWidth/4,screenHeight/2,0,3*screenHeight/4);

	g.setColor(155,100,155);	
	g.fillTriangle(screenWidth/8,3*screenHeight/4,0,screenHeight,screenWidth/4,screenHeight);

	g.setColor(15,255,255);	
	g.fillRect(screenWidth/2,0,screenWidth/4, screenHeight/4);

	g.setColor(255,15,255);	
	g.fillArc(screenWidth/2,screenHeight/4,screenWidth/4, screenHeight/4,135,270);

	g.setColor(255,255,15);	
	g.setStrokeStyle(Graphics.DOTTED);
	g.drawRect(screenWidth/2,screenHeight/2,screenWidth/4, screenHeight/4);

	g.setColor(15,15,255);	
	g.fillArc(screenWidth/2,3*screenHeight/4,screenWidth/4, screenHeight/4,0,360);


    }

    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) {
            case Command.EXIT:
                midlet.destroyApp( false );
                midlet.notifyDestroyed();
                break;
        }
    }
}
