package hello;

import javax.microedition.lcdui.*;

public class SimpleForm extends Form implements CommandListener, ItemStateListener 
{
    TextField   txtName;
    TextField   txtBrirthdate;
    StringItem  txtLog;
    ChoiceGroup cgSex;
    Gauge       gSatisfaction;

    public SimpleForm() 
    {        
        super("Dane osobowe");
        addCommand( new Command( "Koniec", Command.EXIT, 1 ) );

        setCommandListener( this );
	setItemStateListener( this );

	append(new StringItem("Wypelnij pola:","",Item.HYPERLINK));

	append(txtName = new TextField("Nazwisko:","",15,TextField.ANY));
	append(txtBrirthdate = new TextField("Rok urodzenia:","",4,TextField.NUMERIC));

	append(cgSex = new ChoiceGroup("Plec:",Choice.EXCLUSIVE,
               new String[] { "Mezczyzna", "Kobieta"},null));

	append(gSatisfaction = new Gauge("Zadowolenie",true,15,0));

	append(txtLog = new StringItem("Historia zdarzen:","",Item.HYPERLINK));    

	Display.getDisplay(HelloMidlet.getMidlet()).setCurrent(this);
    }
    
    public void commandAction( Command c, Displayable d ) 
    {
        if( c.getCommandType() == Command.EXIT ) 
        {
            HelloMidlet.getMidlet().Exit();
        }
    }

    public void itemStateChanged(Item item)
    {
	if(item == txtName)
	{
	   txtLog.setText("Zmieniles nazwisko - aktualna wartosc to: " + txtName.getString());
	}
	else if(item == txtBrirthdate)
	{
	   txtLog.setText("Zmieniles rok urodzenia - aktualna wartosc to: " + txtBrirthdate.getString());
	}
	else if(item == cgSex)
	{
	   int selectedIndex = cgSex.getSelectedIndex();
	   txtLog.setText("Zmieniles plec - aktualna wartosc to: " + cgSex.getString(selectedIndex));
	}
	else if(item == gSatisfaction)
        {
	   txtLog.setText("Zmieniles stopien zadowolenia - aktualna wartosc to: " + gSatisfaction.getValue());
	}
    }
}
