package hello;

import javax.microedition.lcdui.*;

public class MyCanvas extends Canvas implements CommandListener{
    
    HelloMidlet midlet;    
    boolean isAlive = false;
    int xPos;
    int yPos;
    int xMove=0;
    int yMove=0;
    
    public MyCanvas(HelloMidlet _midlet) 
    {
	midlet = _midlet;
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
	setCommandListener(this);
	
	xPos=getWidth()/2;
	yPos=getHeight()/2;
	
        HeartBeat t = new HeartBeat();
	isAlive=true;
        t.start();
    }
    
    protected void paint(Graphics g) {
	
	int screenWidth  = getWidth();
	int screenHeight = getHeight();
	
	g.fillRect(0,0,screenWidth, screenHeight);
	
	g.setColor(10,10,240);	
	g.fillRect(xPos, yPos,16,16);
    }
    
    protected void keyPressed(int keyCode)
    {
	int gameAction = getGameAction(keyCode);
	
	switch(gameAction)
	{
	    case UP:    yMove=-1; break;
	    case DOWN:  yMove=+1; break;
	    case LEFT:  xMove=-1; break;
	    case RIGHT: xMove=+1; break;
	}
    }
    
    protected void keyReleased(int keyCode)
    {
	int gameAction = getGameAction(keyCode);
	
	switch(gameAction)
	{
	    case UP:   case DOWN:  yMove=0; break;
	    case LEFT: case RIGHT: xMove=0; break;
	}
    }
    
    protected void update()
    {
	xPos+=xMove;
	yPos+=yMove;
	
	repaint();
	serviceRepaints();
    }
    
    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) {
            case Command.EXIT:
	    isAlive	= false;
	    midlet.destroyApp( false );
	    midlet.notifyDestroyed();
	    break;
        }
    }
    
    private class HeartBeat extends Thread 
    {    
        public void run() {            
	    while(isAlive==true)
	    {
		try 
		{
		    sleep(100);
		    update();
		}
		catch(Exception e)
		{
		    isAlive = false;
		    System.out.println("Exception on update thread");
		}
	    }
	    System.out.println("Leaving update thread!");
        }
    }
}
