package hello;

import java.io.*;
import javax.microedition.lcdui.*;

public class MyCanvas extends Canvas implements CommandListener{
    
    final int dynImgWidth  = 64;
    final int dynImgHeight = 64;
    
    HelloMidlet midlet;
    Image myImage;
    
    public MyCanvas(HelloMidlet _midlet) 
    {
        midlet = _midlet;
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
        setCommandListener(this);
        
        createDynamicImage();
    }
    
    protected void createDynamicImage()
    {
        myImage = Image.createImage(dynImgWidth,dynImgHeight);
        
        Graphics dynImgGraphics = myImage.getGraphics();
	
        // rysuj szachownice
        dynImgGraphics.setColor(0,0,0);
        dynImgGraphics.fillRect(0,0,dynImgWidth/2,dynImgHeight/2);
        dynImgGraphics.fillRect(dynImgWidth/2,dynImgHeight/2,dynImgWidth/2,dynImgHeight/2);
        dynImgGraphics.setColor(255,255,21);
        dynImgGraphics.fillRect(dynImgWidth/2,0,dynImgWidth/2,dynImgHeight/2);
        dynImgGraphics.fillRect(0,dynImgHeight/2,dynImgWidth/2,dynImgHeight/2);
	
        // rysuj pionki
        dynImgGraphics.setColor(0,0,0);
        dynImgGraphics.drawRect(5*dynImgWidth/8,dynImgHeight/8,
	dynImgWidth/4,dynImgHeight/4);
	
        dynImgGraphics.drawRect(dynImgWidth/8,5*dynImgHeight/8,
	dynImgWidth/4,dynImgHeight/4);
	
        dynImgGraphics.setColor(255,255,21);            
	
        dynImgGraphics.drawArc(dynImgWidth/8,dynImgHeight/8,
	dynImgWidth/4,dynImgHeight/4,
	0,360);
        dynImgGraphics.drawArc(5*dynImgWidth/8,5*dynImgHeight/8,
	dynImgWidth/4,dynImgHeight/4,
	0,360);
    }
    
    protected void paint(Graphics g) {
	
        int screenWidth  = getWidth();
        int screenHeight = getHeight();
	
        g.fillRect(0,0,screenWidth, screenHeight);
        // rysuj na srodku
        g.drawImage(myImage,screenWidth/2, screenHeight/2, Graphics.VCENTER | Graphics.HCENTER);
    }
    
    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) {
            case Command.EXIT:
	    midlet.destroyApp( false );
	    midlet.notifyDestroyed();
	    break;
        }
    }
}
