/*
 * Decompiled with CFR 0.152.
 */
package mypackage;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import mypackage.Player;

public class Raycaster
extends Canvas {
    public static final int screenHeight = 200;
    public static final int screenWidth = 180;
    public static final int screenHalfHeight = 50;
    public static final int maxDistance = 40;
    private Player player;
    private int halfViewAngle = 45;
    private int[][] worldMap = new int[][]{{4, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {4, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
    private int[] arrX = new int[]{1, -1, -1, 1};
    private int[] arrY = new int[]{1, 1, -1, -1};

    private void initialize() {
        this.player = new Player(this);
        this.player.setPos(2.5f, 1.5f);
    }

    public int getMapPoint(int n, int n2) {
        return this.worldMap[n][n2];
    }

    public Raycaster() {
        this.initialize();
    }

    public void paint(Graphics graphics) {
        int n = this.player.getAngle() % 360;
        if (n < 0) {
            n += 360;
        }
        graphics.fillRect(0, 0, 180, 200);
        this.Render(graphics, n, this.player.getPosX(), this.player.getPosY());
    }

    private double Cos(double d) {
        return Math.cos(Math.toRadians(d));
    }

    private double Sin(double d) {
        return Math.sin(Math.toRadians(d));
    }

    public void Render(Graphics graphics, int n, double d, double d2) {
        int n2 = 0;
        for (int i = n - this.halfViewAngle; i < n + this.halfViewAngle; ++i) {
            int n3 = (int)d;
            int n4 = (int)d2;
            double d3 = 1.0 - (d - (double)n3);
            double d4 = 1.0 - (d2 - (double)n4);
            double d5 = Math.abs(1.0 / this.Cos(i));
            double d6 = Math.abs(1.0 / this.Sin(i));
            double d7 = d3 * d5;
            double d8 = d4 * d6;
            int n5 = i % 360 / 90;
            int n6 = this.arrX[n5];
            int n7 = this.arrY[n5];
            double d9 = 0.0;
            boolean bl = false;
            int n8 = 1;
            while (!bl) {
                if (d7 > d8) {
                    if (0 != this.worldMap[n3][n4 += n7]) {
                        bl = true;
                        d9 = d8;
                        continue;
                    }
                    d8 += d6;
                    continue;
                }
                if (0 != this.worldMap[n3 += n6][n4]) {
                    bl = true;
                    d9 = d7;
                    n8 = 2;
                    continue;
                }
                d7 += d5;
            }
            graphics.setColor(160 / n8, 160 / n8, 255 / n8);
            d9 *= this.Cos(n - i);
            d9 = 30.0 / d9;
            graphics.drawLine(n2, 50 - (int)d9, n2, 50 + (int)d9);
            ++n2;
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.player.RotateLeft();
                break;
            }
            case 5: {
                this.player.RotateRight();
                break;
            }
            case 1: {
                this.player.MoveForward();
                break;
            }
            case 6: {
                this.player.MoveBackward();
            }
        }
        this.repaint();
        this.serviceRepaints();
    }
}

