package pakiet_program_notatki;
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import java.util.*;
public class program_notatki_MIDlet extends MIDlet implements CommandListener
{
	public program_notatki_MIDlet()
	{
		zbior = new MenadzerDanych("zbior");
		lista = new List("Program Notatki",Choice.IMPLICIT);
		Command pokaz = new Command("Pokaz",Command.ITEM,0);
		Command dodaj = new Command("Dodaj",Command.ITEM,1);
		Command koniec = new Command("Koniec",Command.EXIT,0);
		lista.addCommand(dodaj);
		lista.addCommand(pokaz);
		lista.addCommand(koniec);
		lista.setCommandListener(this);
		formapokaz = new Form("Pokaz notatki");
		pelnatresc = formapokaz.append(new StringItem("",""));
		Command pokaz_powrot = new Command("Powrot",Command.EXIT,0);
		formapokaz.addCommand(pokaz_powrot);
		formapokaz.setCommandListener(this);
		formadodaj = new Form("Dodawanie notatki");
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
		pole_rok = new TextField("Rok:",cal.get(Calendar.YEAR)+"",4,TextField.NUMERIC);
		pole_mies = new TextField("Miesiac:",(cal.get(Calendar.MONTH)+1)+"",2,TextField.NUMERIC);
		pole_dzien = new TextField("Dzien:",cal.get(Calendar.DAY_OF_MONTH)+"",2,TextField.NUMERIC);
		pole_godz = new TextField("Godzina:",(cal.get(Calendar.HOUR_OF_DAY)+2)+"",2,TextField.NUMERIC);
		pole_min = new TextField("Minuta:",cal.get(Calendar.MINUTE)+"",2,TextField.NUMERIC);
		pole_sek = new TextField("Sekunda:",cal.get(Calendar.SECOND)+"",2,TextField.NUMERIC);
		pole_nazwa = new TextField("Nazwa:","",50,TextField.ANY);
		pole_opis = new TextField("Opis:","",150,TextField.ANY);
		formadodaj.append(pole_rok);
		formadodaj.append(pole_mies);
		formadodaj.append(pole_dzien);
		formadodaj.append(pole_godz);
		formadodaj.append(pole_min);
		formadodaj.append(pole_sek);
		formadodaj.append(pole_nazwa);
		formadodaj.append(pole_opis);
		komunikat = formadodaj.append(new StringItem("",""));
		Command dodaj_dodaj = new Command("Dodaj",Command.OK,0);
		Command dodaj_powrot = new Command("Powrot",Command.EXIT,0);
		formadodaj.addCommand(dodaj_dodaj);
		formadodaj.addCommand(dodaj_powrot);
		formadodaj.setCommandListener(this);
		ekran = Display.getDisplay(this);
		ekran.setCurrent(lista);
	}
	public void wczytaj()
	{
		try
		{
			zbior.usunStare();
			notatki = zbior.pobierzAktualne();
		}
		catch (RecordStoreException rse)
		{
			rse.printStackTrace();
		}
		lista.deleteAll();
		for (int i=0;i<notatki.length;i++)
			lista.append(notatki[i].getNazwa(),null);
	}
	public void startApp()
	{
		this.wczytaj();
	}
	public void pauseApp(){}
	public void destroyApp(boolean u)
	{
		zbior.koniec();
	}
	public void commandAction(Command c, Displayable s)
	{
		if (s == lista)
		{
			if (c.getCommandType() == Command.ITEM)
			{
				if (c.getPriority() == 0 && lista.getSelectedIndex()>-1)
				{
					Notatka not = notatki[lista.getSelectedIndex()];
					String tresc = not.getNazwa()+"\r\n"+not.getOpis()+"\r\n"+not.getPelnaData();
					formapokaz.set(pelnatresc,new StringItem("Notatka:",tresc));
					ekran.setCurrent(formapokaz);
				}
				if (c.getPriority() == 1)
				{
					ekran.setCurrent(formadodaj);
				}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				this.destroyApp(true);
				this.notifyDestroyed();
			}
		}
		if (s == formadodaj)
		{
			if (c.getCommandType() == Command.OK)
			{
				int r = Integer.parseInt(pole_rok.getString());
				int m = Integer.parseInt(pole_mies.getString())-1;
				int d = Integer.parseInt(pole_dzien.getString());
				int g = Integer.parseInt(pole_godz.getString())-2;
				int min = Integer.parseInt(pole_min.getString());
				int sek = Integer.parseInt(pole_sek.getString());
				String nazwa = pole_nazwa.getString();
				String opis = pole_opis.getString();
				if (!nazwa.equals("") && !opis.equals(""))
				{
					long data = Notatka.PelnaDatawData(r,m,d,g,min,sek);
					if (data>System.currentTimeMillis())
					{
						Notatka not = new Notatka(nazwa, opis, data);
						zbior.dodajNotatke(not);
						formadodaj.set(komunikat,new StringItem("","Dodano rekord!"));
					}
				}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				formadodaj.set(komunikat,new StringItem("",""));
				this.wczytaj();
				ekran.setCurrent(lista);
			}
		}
		if (s == formapokaz)
		{
			if (c.getCommandType() == Command.EXIT)
				ekran.setCurrent(lista);
		}
	}
	private MenadzerDanych zbior;
	private Notatka[] notatki = new Notatka[0];
	private List lista;
	private Form formapokaz;
	private Form formadodaj;
	private TextField pole_rok;
	private TextField pole_mies;
	private TextField pole_dzien;
	private TextField pole_godz;
	private TextField pole_min;
	private TextField pole_sek;
	private TextField pole_nazwa;
	private TextField pole_opis;
	private int komunikat;
	private int pelnatresc;
	private Display ekran;
}
