package pakiet_program_notatki;
import javax.microedition.rms.*;
public class MenadzerDanych 
{
	public MenadzerDanych(String nazwa)
	{
		try
		{
			zrodlo = RecordStore.openRecordStore(nazwa,true);
		}
		catch (RecordStoreException rse)
		{
			rse.printStackTrace();
		}
	}
	public void dodajNotatke(Notatka not)
	{
		byte[] bufor = not.toByteArray();
		try
		{
			zrodlo.addRecord(bufor,0,bufor.length);
		}
		catch (RecordStoreException rsfe)
		{
			rsfe.printStackTrace();
		}
	}
	public void usunStare() throws RecordStoreException
	{
		try
		{
			RecordEnumeration prz = zrodlo.enumerateRecords(new Filtr(true),null,true);
			while (prz.hasNextElement())
			{
				int ID = prz.nextRecordId();
				zrodlo.deleteRecord(ID);
				prz.rebuild();
			}
		}
		catch (RecordStoreException rse)
		{
			rse.printStackTrace();
		}
	}
	public Notatka[] pobierzAktualne() throws RecordStoreException
	{
		RecordEnumeration prz = zrodlo.enumerateRecords(new Filtr(false),new SortownikAktualnych(),false);
		Notatka[] wyniki = new Notatka[prz.numRecords()];
		int i=0;
		while (prz.hasNextElement())
		{
			wyniki[i] = new Notatka(prz.nextRecord());
			i+=1;
		}
		return wyniki;
	}
	public void koniec()
	{
		try
		{
			zrodlo.closeRecordStore();
		}
		catch (RecordStoreException rse)
		{
			rse.printStackTrace();
		}
	}
	private RecordStore zrodlo;
	class Filtr implements RecordFilter
	{
		public Filtr(boolean p_czyStare)
		{
			data = System.currentTimeMillis();
			czyStare = p_czyStare;
		}
		public boolean matches(byte[] rekord)
		{
			Notatka not = new Notatka(rekord);
			return (czyStare?(not.getData()<data):(not.getData()>=data));
		}
		private long data;
		private boolean czyStare;
	}
	class SortownikAktualnych implements RecordComparator
	{
		public int compare(byte[] rekord1, byte[] rekord2)
		{
			Notatka not1 = new Notatka(rekord1);
			Notatka not2 = new Notatka(rekord2);
			if (not1.getData()>not2.getData())
				return RecordComparator.FOLLOWS;
			if (not1.getData()<not2.getData())
				return RecordComparator.PRECEDES;
			return RecordComparator.EQUIVALENT;
		}
	}
}
