package pakiet_gra_platformowa;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.*;
public class Bohater extends ObiektRuchomy implements WarunkiStrzelania
{
 public Bohater(Image _obraz, int _nr_planszy_x, int _nr_planszy_y, TiledLayer _tlo, Plotno _plotno)
 {
  super(_obraz, _tlo, _nr_planszy_x, _nr_planszy_y);
  tlo = _tlo;
  plotno = _plotno;
 }
 public byte aktualizujMenadzera(int k)
 {
	 if (k == 2)
	 {
		 plotno.odswiezMenadzera(nr_planszy_x, nr_planszy_y);
		 return 1;
	 } else
		 return (byte)k;
 }
 public byte przesunLewo(int x)
 {
  int k = super.przesunLewo(x);
  return this.aktualizujMenadzera(k);
 }
 public byte przesunGora(int y)
 {
  int k = super.przesunGora(y);
  return this.aktualizujMenadzera(k);
 }
 public byte przesunDol(int y)
 {
  int k = super.przesunDol(y);
  return this.aktualizujMenadzera(k);
 }
 public byte przesunPrawo(int x)
 {
  int k = super.przesunPrawo(x);
  return this.aktualizujMenadzera(k);
 }
 public boolean dotarlDoKonca()
 {
  int endx = xkoniec*Plotno.WYMIAR_PL+Plotno.WYMIAR_PL/2;
  int endy = ykoniec*Plotno.WYMIAR_PL+Plotno.WYMIAR_PL*3/4;
  if (endx>=this.getX()&&endx<=this.getX()+this.getWidth()&&endy>=this.getY()&&endy<=this.getY()+this.getHeight())
   return true;
  else return false;
 }
 public void setKoniec(int x, int y)
 {
  xkoniec = x;
  ykoniec = y;
 }
 public boolean kolizja()
 {
  Potworki potworki = plotno.getPotworki();
  if (potworki==null) return false;
  for (int i=0;i<potworki.getDlugosc();i++)
  {
   if (this.collidesWith(potworki.getPotworek(i),true))
   return true;
  }
  return false;
 }
 public void strzel()
 {
  this.stanbroni = 0;
  try
  {
   plotno.getPociski().utworzPocisk(this, tlo, Pocisk.BOHATER);
  }
  catch (Exception e)
  {
   plotno.zakonczGre();
  }
 }
 public void laduj()
 {
  this.stanbroni += 1;
 }
 public boolean mozeStrzelac()
 {
  return (this.stanbroni>=4);
 }
 private Plotno plotno;
 private TiledLayer tlo;
 private int stanbroni = 5;
 private int xkoniec;
 private int ykoniec;
}