package pakiet_program_notatki;
import java.util.*;
import java.io.*;
public class Notatka 
{
	public Notatka(String p_nazwa, String p_opis, long p_data)
	{
		nazwa = p_nazwa;
		opis = p_opis;
		data = p_data;
	}
	public long getData()
	{
		return data;
	}
	public String getNazwa()
	{
		return nazwa;
	}
	public String getOpis()
	{
		return opis;
	}
	public Notatka(byte[] dane)
	{
		try
		{
			DataInputStream in = new DataInputStream(new ByteArrayInputStream(dane));
			this.nazwa = in.readUTF();
			this.opis = in.readUTF();
			this.data = in.readLong();
			in.close();
		}
		catch (IOException ioe)
		{
			ioe.printStackTrace();
		}
	}
	public byte[] toByteArray()
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(baos);
		byte bufor[] = new byte[0];
		try
		{
			out.writeUTF(this.nazwa);
			out.writeUTF(this.opis);
			out.writeLong(this.data);
			bufor = baos.toByteArray();
			baos.close();
		}
		catch (IOException ioe)
		{
			ioe.printStackTrace();
		}
		return bufor;
	}
	public static long PelnaDatawData(int rok, int mies, int dzien, int godz, int min, int sek)
	{
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
		cal.set(Calendar.YEAR, rok);
		cal.set(Calendar.MONTH, mies);
		cal.set(Calendar.DAY_OF_MONTH, dzien);
		cal.set(Calendar.HOUR_OF_DAY, godz);
		cal.set(Calendar.MINUTE, min);
		cal.set(Calendar.SECOND, sek);
		return cal.getTime().getTime();
	}
	private String zero(int wartosc)
	{
		if (wartosc<10)
			return "0"+wartosc;
		else
			return ""+wartosc;
	}
	public String getPelnaData()
	{
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
		Date obiekt_data = new Date(this.data);
		cal.setTime(obiekt_data);
		String wynik = cal.get(Calendar.YEAR)+"-";
		wynik += zero(cal.get(Calendar.MONTH)+1)+"-";
		wynik += zero(cal.get(Calendar.DAY_OF_MONTH))+" ";
		wynik += zero(cal.get(Calendar.HOUR_OF_DAY)+2)+":";
		wynik += zero(cal.get(Calendar.MINUTE))+":";
		wynik += zero(cal.get(Calendar.SECOND));
		return wynik;
	}
	private String nazwa;
	private String opis;
	private long data;
}
