package pakiet_program_graficzny;
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
public class program_graficzny_MIDlet extends MIDlet implements CommandListener 
{
	public program_graficzny_MIDlet()
	{
		plotno = new Plotno();
		Command zaznacz = new Command("Zaznacz",Command.EXIT,0);
		Command prostokat = new Command("Prostokat",Command.ITEM,0);
		Command kolo = new Command("Trojkat", Command.ITEM,1);
		Command linia = new Command("Linia", Command.ITEM,2);
		Command zmien = new Command("Zmien kolor",Command.ITEM,3);
		plotno.addCommand(zaznacz);
		plotno.addCommand(prostokat);
		plotno.addCommand(kolo);
		plotno.addCommand(linia);
		plotno.addCommand(zmien);
		plotno.setCommandListener(this);
		zmianakoloru = new Form("Zmiana koloru");
		poler = new TextField("Skladowa R:","0",3,TextField.NUMERIC);
		poleg = new TextField("Skladowa G:","0",3,TextField.NUMERIC);
		poleb = new TextField("Skladowa B:","0",3,TextField.NUMERIC);
		zmianakoloru.append(poler);
		zmianakoloru.append(poleg);
		zmianakoloru.append(poleb);
		Command ok = new Command("OK",Command.OK,0);
		zmianakoloru.addCommand(ok);
		zmianakoloru.setCommandListener(this);
		ekran = Display.getDisplay(this);
		ekran.setCurrent(plotno);
	}
	public void commandAction(Command c, Displayable s)
	{
		if (s == plotno)
		{
			if (c.getCommandType() == Command.EXIT)
				plotno.zaznacz();
			if (c.getCommandType() == Command.ITEM)
			{
				if (c.getPriority() == 0)
					plotno.ustawFigure("prostokat");
				if (c.getPriority() == 1)
					plotno.ustawFigure("trojkat");
				if (c.getPriority() == 2)
					plotno.ustawFigure("linia");
				if (c.getPriority() == 3)
					ekran.setCurrent(zmianakoloru);
			}
		}
		if (s == zmianakoloru)
		{
			if (c.getCommandType() == Command.OK)
			{
				int r = Integer.parseInt(poler.getString());
				int g = Integer.parseInt(poleg.getString());
				int b = Integer.parseInt(poleb.getString());
				if (r>=0 && r<=255 && g>=0 && g<=255 && b>=0 && b<=255)
				{
					plotno.ustawKolor(r,g,b);
					ekran.setCurrent(plotno);
				}
			}
		}
	}
	public void startApp(){}
	public void pauseApp(){}
	public void destroyApp(boolean u){}
	private Display ekran;
	private Plotno plotno;
	private Form zmianakoloru;
	private TextField poler;
	private TextField poleg;
	private TextField poleb;
}
