package pakiet_program_bluetooth_test;
import javax.bluetooth.*;
import javax.microedition.io.*;
import java.io.*;
public class SerwerBT implements Runnable
{
	public SerwerBT(Bluetooth_Test_MIDlet _m)
	{
		m = _m;
		Thread w = new Thread(this);
		w.start();
	}
	public void run()
	{
		try
		{
			urzadzenie = LocalDevice.getLocalDevice();
			urzadzenie.setDiscoverable(DiscoveryAgent.GIAC);
			String url = "btspp://localhost:"+UUID_SERWERA.toString()+";name="+NAZWA+";authorize=false";
			powiadamiacz = (StreamConnectionNotifier)Connector.open(url);
			usluga = urzadzenie.getRecord(powiadamiacz);
			DataElement parametr = new DataElement(DataElement.INT_1,1);
			usluga.setAttributeValue(ATRYBUT_WERSJI,parametr);
		} catch (Exception e)
		{
			e.printStackTrace();
			this.koniec();
			m.notifyDestroyed();
		}
		while (madzialac)
		{
			try
			{
				pol = powiadamiacz.acceptAndOpen();
				String dane = this.wykonaj();
				String rezultat = this.rot13(dane);
				this.wyslij(rezultat);
				pol.close();
				pol = null;
			} catch (Exception e)
			{
				e.printStackTrace();
				this.koniec();
				m.notifyDestroyed();
			}
		}
	}
	public String wykonaj() throws Exception
	{
		InputStream wej = pol.openInputStream();
		int dlugosc = wej.read();
		byte[] bufor = new byte[dlugosc];
		int licznik = 0;
		while (licznik<dlugosc)
		{
			int liczba = wej.read(bufor,licznik,dlugosc-licznik);
			licznik += liczba;
		}
		wej.close();
		return new String(bufor,"ISO-8859-1");
	}
	public void wyslij(String dane) throws Exception
	{
		OutputStream out = pol.openOutputStream();
		out.write(dane.getBytes("ISO-8859-1"));
		out.flush();
		out.close();
	}
	public void koniec()
	{
		if (powiadamiacz!=null)
		{
			try
			{
				madzialac = false;
				if (pol!=null)
				pol.close();
				powiadamiacz.close();
			} catch (Exception e){}
		}
	}
	public String rot13(String dane)
	{
		String wynik = new String(dane);
		for (int i=0;i<dane.length();i++)
			wynik = wynik.substring(0,i)+zamien13(wynik.charAt(i))+wynik.substring(i+1,wynik.length());
		return wynik;
	}
	private char zamien13(char ch)
	{
		int kod = (byte)ch;
		if (kod>=97 && kod<=122)
		{
			kod += 13;
			if (kod>122)
				kod = kod - 26;
		} else
		if (kod>=65 && kod <=90)
		{
			kod += 13;
			if (kod>90)
				kod = kod - 26;
		} else
			kod = 32;
		return (char)kod;
	}
	private LocalDevice urzadzenie;
	private ServiceRecord usluga;
	private StreamConnectionNotifier powiadamiacz;
	private StreamConnection pol = null;
	private Bluetooth_Test_MIDlet m;
	private boolean madzialac = true;
	private static final int ATRYBUT_WERSJI = 0x3232;
	private static final UUID UUID_SERWERA = 
		new UUID("ABCDEF12345678998877665544332211", false);
	private static final String NAZWA = "SERWER_KRYPT";
}
