package przegladarkapakiet;
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.Sprite;
import java.io.IOException;
public class przegladarkaMIDlet extends MIDlet implements CommandListener
{
	public przegladarkaMIDlet()
	{
		Form formatka = new Form("Przegladarka obrazow");
		pole_nazwa = new TextField("Podaj nazwe pliku:","",75, TextField.ANY);
		opcje = new ChoiceGroup("Wybierz rodzaj przeksztalcenia",Choice.EXCLUSIVE,PRZEKSZTALCENIA,null);
		opcje.setSelectedIndex(0,true);
		obraz = new ImageItem("Obraz:",null,ImageItem.LAYOUT_LEFT,"Tekst zastepczy");
		komunikat = new Ticker("MIDlet \"Przegladarka Obrazow\"");
		formatka.append(obraz);
		formatka.append(pole_nazwa);
		formatka.append(opcje);
		formatka.setTicker(komunikat);
		Command wczytaj = new Command("Wczytaj",Command.OK,0);
		Command koniec = new Command("Koniec",Command.EXIT,0);
		formatka.addCommand(wczytaj);
		formatka.addCommand(koniec);
		formatka.setCommandListener(this);
		Display ekran = Display.getDisplay(this);
		ekran.setCurrent(formatka);
	}
	protected void startApp() {}
	protected void pauseApp() {}
	protected void destroyApp(boolean arg0) {}
	public void commandAction(Command c, Displayable s)
	{
		if (c.getCommandType() == Command.OK)
		{
			if (!pole_nazwa.getString().equals(""))
			{
				try
				{
					Image im = Image.createImage(pole_nazwa.getString());
					int indeks = opcje.getSelectedIndex();
					int transformacja = PRZEKSZTALCENIA_WARTOSCI[indeks];
					Image obrazek = Image.createImage(im,0,0,im.getWidth(),im.getHeight(),transformacja);
					obraz.setImage(obrazek);
					komunikat.setString("MIDlet \"Przegladarka Obrazow\"");
				}
				catch (IOException ioe)
				{
					komunikat.setString("Blad wczytywania pliku");
					ioe.printStackTrace();
				}
			}
		}
		if (c.getCommandType() == Command.EXIT)
			this.notifyDestroyed();
	}
	private TextField pole_nazwa;
	private ImageItem obraz;
	private ChoiceGroup opcje;
	private Ticker komunikat;
	private static final String[] PRZEKSZTALCENIA =
	{ "Brak", "Odbicie lustrzane", "Obrot o 180 st." };
	private static final int[] PRZEKSZTALCENIA_WARTOSCI = 
	{ Sprite.TRANS_NONE, Sprite.TRANS_MIRROR, Sprite.TRANS_ROT180};
}
