/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.parser;

import java.io.IOException;
import java.util.Vector;
import org.kxml.io.ParseException;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;

public abstract class AbstractXmlParser {
    protected boolean processNamespaces = true;

    public void ignoreTree() throws IOException {
        this.readTree(null);
    }

    public void readTree(Vector vector) throws IOException {
        StartTag startTag = (StartTag)this.read();
        block4: while (true) {
            ParseEvent parseEvent = this.peek();
            if (vector != null) {
                vector.addElement(parseEvent);
            }
            switch (parseEvent.getType()) {
                case 64: {
                    this.readTree(vector);
                    continue block4;
                }
                case 8: 
                case 16: {
                    this.read();
                    return;
                }
            }
            this.read();
        }
    }

    public int getLineNumber() throws IOException {
        return this.peek().getLineNumber();
    }

    public abstract ParseEvent read() throws IOException;

    public ParseEvent read(int n, String string, String string2) throws IOException {
        if (this.peek(n, string, string2)) {
            return this.read();
        }
        throw new ParseException("unexpected: " + this.peek(), null, this.peek().getLineNumber(), -1);
    }

    public boolean peek(int n, String string, String string2) throws IOException {
        ParseEvent parseEvent = this.peek();
        return !(parseEvent.getType() != n || string != null && !string.equals(parseEvent.getNamespace()) || string2 != null && !string2.equals(parseEvent.getName()));
    }

    public void skip() throws IOException {
        int n;
        while ((n = this.peek().type) == 1 || n == 2 || n == 32 || n == 256) {
            this.read();
        }
    }

    public abstract ParseEvent peek() throws IOException;

    public void setProcessNamespaces(boolean bl) {
        this.processNamespaces = bl;
    }

    public String readText() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        block5: while (true) {
            ParseEvent parseEvent = this.peek();
            switch (parseEvent.getType()) {
                case 2: 
                case 8: 
                case 64: {
                    throw new RuntimeException("Illegal event: " + parseEvent);
                }
                case 128: 
                case 256: {
                    this.read();
                    stringBuffer.append(parseEvent.getText());
                    continue block5;
                }
                case 16: {
                    return stringBuffer.toString();
                }
            }
            this.read();
        }
    }
}

