/*
 * Decompiled with CFR 0.152.
 */
package pakiet_program_notatki;

import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import pakiet_program_notatki.Notatka;

public class MenadzerDanych {
    private RecordStore zrodlo;

    public MenadzerDanych(String nazwa) {
        try {
            this.zrodlo = RecordStore.openRecordStore((String)nazwa, (boolean)true);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
    }

    public void dodajNotatke(Notatka not) {
        byte[] bufor = not.toByteArray();
        try {
            this.zrodlo.addRecord(bufor, 0, bufor.length);
        }
        catch (RecordStoreException rsfe) {
            rsfe.printStackTrace();
        }
    }

    public void usunStare() throws RecordStoreException {
        try {
            RecordEnumeration prz = this.zrodlo.enumerateRecords((RecordFilter)new Filtr(true), null, true);
            while (prz.hasNextElement()) {
                int ID = prz.nextRecordId();
                this.zrodlo.deleteRecord(ID);
                prz.rebuild();
            }
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
    }

    public Notatka[] pobierzAktualne() throws RecordStoreException {
        RecordEnumeration prz = this.zrodlo.enumerateRecords((RecordFilter)new Filtr(false), (RecordComparator)new SortownikAktualnych(), false);
        Notatka[] wyniki = new Notatka[prz.numRecords()];
        int i = 0;
        while (prz.hasNextElement()) {
            wyniki[i] = new Notatka(prz.nextRecord());
            ++i;
        }
        return wyniki;
    }

    public void koniec() {
        try {
            this.zrodlo.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
    }

    class Filtr
    implements RecordFilter {
        private long data = System.currentTimeMillis();
        private boolean czyStare;

        public Filtr(boolean p_czyStare) {
            this.czyStare = p_czyStare;
        }

        public boolean matches(byte[] rekord) {
            Notatka not = new Notatka(rekord);
            return this.czyStare ? not.getData() < this.data : not.getData() >= this.data;
        }
    }

    class SortownikAktualnych
    implements RecordComparator {
        SortownikAktualnych() {
        }

        public int compare(byte[] rekord1, byte[] rekord2) {
            Notatka not1 = new Notatka(rekord1);
            Notatka not2 = new Notatka(rekord2);
            if (not1.getData() > not2.getData()) {
                return 1;
            }
            if (not1.getData() < not2.getData()) {
                return -1;
            }
            return 0;
        }
    }
}

