/*
 * Decompiled with CFR 0.152.
 */
package pakiet_program_odtwarzacz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.RecordControl;
import javax.microedition.media.control.VideoControl;
import pakiet_program_odtwarzacz.CzytnikDanych;
import pakiet_program_odtwarzacz.program_odtwarzacz_MIDlet;

public class Odtwarzacz {
    private Player p;
    private program_odtwarzacz_MIDlet m;
    private VideoControl vc;
    private VideoControl aparat;
    private RecordControl rc;
    private ByteArrayOutputStream baos;
    private String sciezka;
    private CzytnikDanych czytnik;
    private byte[] bufor = new byte[0];
    private boolean tryb;
    private boolean nagrywa = false;
    private String typ_zdjecia;

    public Odtwarzacz(program_odtwarzacz_MIDlet p_m) {
        this.m = p_m;
        this.czytnik = new CzytnikDanych(p_m);
        this.typ_zdjecia = this.pobierzDomyslnyTyp();
    }

    public boolean odtwarzaj() {
        Item it = null;
        if (this.tryb && this.p != null && this.p.getState() == 200) {
            this.vc = (VideoControl)this.p.getControl("VideoControl");
            if (this.vc != null) {
                it = (Item)this.vc.initDisplayMode(0, null);
            }
        }
        if (this.p != null && this.p.getState() == 200) {
            try {
                this.m.wlaczWyswietlacz(it);
                this.p.prefetch();
                this.p.start();
                return true;
            }
            catch (MediaException me) {
                me.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public void przechwyc(boolean czyStart) {
        try {
            if (czyStart) {
                if (!this.nagrywa) {
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                Odtwarzacz.this.baos = new ByteArrayOutputStream();
                                Odtwarzacz.this.p = Manager.createPlayer((String)"capture://audio");
                                Odtwarzacz.this.p.realize();
                                Odtwarzacz.this.rc = (RecordControl)Odtwarzacz.this.p.getControl("RecordControl");
                                Odtwarzacz.this.rc.setRecordStream((OutputStream)Odtwarzacz.this.baos);
                                Odtwarzacz.this.rc.startRecord();
                                Odtwarzacz.this.p.start();
                                Odtwarzacz.this.nagrywa = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }).start();
                }
            } else if (this.nagrywa) {
                this.nagrywa = false;
                this.rc.commit();
                this.p.close();
                this.bufor = this.baos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void odtworzNagranie() {
        if (!this.nagrywa && this.bufor.length > 0) {
            try {
                this.p = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.bufor), (String)"audio/x-wav");
                this.p.realize();
                this.p.prefetch();
                this.p.start();
            }
            catch (Exception me) {
                me.printStackTrace();
            }
        }
    }

    public void zapisz(String nazwa) throws Exception {
        if (!this.nagrywa && this.bufor.length > 0) {
            this.czytnik.zapisz(nazwa, this.bufor);
            this.bufor = new byte[0];
        }
    }

    public void zapisz(String nazwa, byte[] dane) throws Exception {
        this.czytnik.zapisz(nazwa, dane);
    }

    public String pobierzDomyslnyTyp() {
        String typy = System.getProperty("video.snapshot.encodings");
        if (typy.indexOf("jpeg") > -1) {
            return "encoding=jpeg";
        }
        if (typy.indexOf("png") > -1) {
            return "encoding=png";
        }
        if (typy.indexOf("gif") > -1) {
            return "encoding=gif";
        }
        return null;
    }

    public String typZdjeciaWTypMIME(String typ) {
        if (typ.equals("encoding=jpeg")) {
            return "image/jpeg";
        }
        if (typ.equals("encoding=png")) {
            return "image/png";
        }
        if (typ.equals("encoding=gif")) {
            return "image/gif";
        }
        return "";
    }

    public void pobierzZdjecie() throws Exception {
        if (this.aparat != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        byte[] bufor_zdjecia = Odtwarzacz.this.aparat.getSnapshot(Odtwarzacz.this.typ_zdjecia);
                        Odtwarzacz.this.zapisz(Odtwarzacz.this.typZdjeciaWTypMIME(Odtwarzacz.this.typ_zdjecia), bufor_zdjecia);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public String[] pobierzID() {
        return this.czytnik.pobierzID();
    }

    public void koniec() {
        try {
            this.czytnik.koniec();
            if (this.p != null && this.p.getState() != 0) {
                this.p.close();
                this.p.deallocate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Item pobierajObraz() {
        Item obraz_aparatu = null;
        try {
            this.p = Manager.createPlayer((String)"capture://video");
            this.p.realize();
            this.aparat = (VideoControl)this.p.getControl("VideoControl");
            if (this.aparat != null) {
                obraz_aparatu = (Item)this.aparat.initDisplayMode(0, null);
            }
            this.p.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obraz_aparatu;
    }

    public boolean jestObrazek(String nazwa) {
        return nazwa.startsWith("image");
    }

    public void przerwij() {
        if (this.p != null && this.p.getState() == 400) {
            try {
                this.p.stop();
                this.p.close();
                this.aparat = null;
            }
            catch (MediaException me) {
                me.printStackTrace();
            }
        }
    }

    public void przygotuj(String p_sciezka) {
        this.sciezka = p_sciezka;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Odtwarzacz.this.p = Odtwarzacz.this.czytnik.analizuj(Odtwarzacz.this.sciezka);
                    if (Odtwarzacz.this.p != null) {
                        Odtwarzacz.this.p.realize();
                        if (Odtwarzacz.this.p.getContentType().equals("video/mpeg")) {
                            Odtwarzacz.this.tryb = true;
                        } else {
                            Odtwarzacz.this.tryb = false;
                        }
                        Odtwarzacz.this.odtwarzaj();
                    } else if (Odtwarzacz.this.jestObrazek(Odtwarzacz.this.czytnik.getTyp())) {
                        Image obraz = Image.createImage((InputStream)Odtwarzacz.this.czytnik.getStrumien());
                        ImageItem it = new ImageItem("", obraz, 3, "");
                        Odtwarzacz.this.m.wlaczWyswietlacz((Item)it);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

