/*
 * Decompiled with CFR 0.152.
 */
package pakiet_gra_platformowa;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.TiledLayer;
import pakiet_gra_platformowa.Bohater;
import pakiet_gra_platformowa.DanePotworka;
import pakiet_gra_platformowa.Gra_platformowa_MIDlet;
import pakiet_gra_platformowa.MenadzerDanych;
import pakiet_gra_platformowa.Pociski;
import pakiet_gra_platformowa.Potworek;
import pakiet_gra_platformowa.Potworki;

public class Plotno
extends GameCanvas
implements Runnable,
CommandListener {
    private short[][] plansza;
    private DanePotworka[][][] dane;
    private Gra_platformowa_MIDlet gra;
    private TiledLayer tlo;
    private Graphics g;
    private Bohater bohater;
    private LayerManager menadzer;
    private Pociski pociski;
    private Random random;
    private boolean kontynuowac = true;
    public static int SZEROKOSC;
    public static int WYSOKOSC;
    private Potworki potworki;
    public static final int PRZERWA = 50;
    public static final int DYSTANS = 2;
    public static final int DYSTANSPOCISK = 4;
    public static final int ENERGIA = 16;
    public static final int WYMIAR_PL = 16;
    public static final int WYMIAR_BOH = 10;
    public static final boolean PRAWO = true;
    public static final boolean LEWO = false;

    public Plotno(boolean keys, Gra_platformowa_MIDlet _gra) {
        super(keys);
        Command c = new Command("Koniec", 7, 0);
        this.setCommandListener(this);
        this.addCommand(c);
        this.gra = _gra;
        MenadzerDanych m = null;
        try {
            m = new MenadzerDanych("/plansza1.dat");
        }
        catch (Exception e) {
            this.zakonczGre();
        }
        this.g = this.getGraphics();
        try {
            this.tlo = new TiledLayer((int)m.getDuzeX(), (int)m.getDuzeY(), Image.createImage((String)"/full.PNG"), 16, 16);
            this.bohater = new Bohater(Image.createImage((String)"/bohater.PNG"), m.getStartPlanszaX(), m.getStartPlanszaY(), this.tlo, this);
            this.bohater.setPosition(16 * m.getPozycjaX(), 16 * m.getPozycjaY());
        }
        catch (IOException e) {
            this.zakonczGre();
        }
        SZEROKOSC = m.getSzerokosc();
        WYSOKOSC = m.getWysokosc();
        this.bohater.setKoniec(m.getXKoncowe(), m.getYKoncowe());
        this.plansza = m.getPlansza();
        this.dane = m.getDane();
        int i = 0;
        while (i < m.getDuzeY()) {
            int j = 0;
            while (j < m.getDuzeX()) {
                this.tlo.setCell(j, i, (int)this.plansza[j][i]);
                ++j;
            }
            ++i;
        }
        this.menadzer = new LayerManager();
        this.menadzer.append((Layer)this.bohater);
        this.menadzer.append((Layer)this.tlo);
        this.menadzer.setViewWindow(0, 0, SZEROKOSC, WYSOKOSC);
        this.pociski = new Pociski(this);
        this.potworki = new Potworki(this);
        this.odswiezMenadzera(m.getStartPlanszaX(), m.getStartPlanszaY());
        this.random = new Random(System.currentTimeMillis());
        Thread watek = new Thread(this);
        watek.start();
    }

    public void commandAction(Command c, Displayable s) {
        this.gra.destroyApp(true);
        this.gra.notifyDestroyed();
    }

    public void zakonczGre() {
        this.gra.wyswietlKomunikat("Blad wczytywania planszy");
        this.gra.destroyApp(true);
        this.gra.notifyDestroyed();
    }

    public void usunZMenadzera(Layer l) {
        this.menadzer.remove(l);
    }

    public void dodajDoMenadzera(Layer l) {
        this.menadzer.insert(l, 1);
    }

    public void odswiezMenadzera(int x, int y) {
        this.menadzer.setViewWindow((x - 1) * SZEROKOSC, (y - 1) * WYSOKOSC, SZEROKOSC, WYSOKOSC);
        int i = 0;
        while (i < this.potworki.getDlugosc()) {
            this.menadzer.remove((Layer)this.potworki.getPotworek(i));
            ++i;
        }
        DanePotworka[] aktualne = this.dane[x - 1][y - 1];
        this.potworki.ustawPotworki(aktualne.length);
        int i2 = 0;
        while (i2 < aktualne.length) {
            try {
                this.potworki.tworzPotworek(new Potworek(Image.createImage((String)"/wrog.PNG"), x, y, this.tlo, 16 * aktualne[i2].getXend(), aktualne[i2].getKierunek(), this), i2);
                this.potworki.getPotworek(i2).setPosition(16 * aktualne[i2].getXstart(), 16 * (aktualne[i2].getY() + 1) - 10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        this.pociski.usunPociski();
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.tlo.getWidth(), this.tlo.getHeight());
        this.menadzer.paint(g, 0, 0);
        this.flushGraphics();
    }

    public void klawiatura() {
        int klawisze = this.getKeyStates();
        if ((klawisze & 4) != 0) {
            this.bohater.setKierunek(false);
            this.bohater.przesunLewo(2);
        }
        if ((klawisze & 0x20) != 0) {
            this.bohater.setKierunek(true);
            this.bohater.przesunPrawo(2);
        }
        if ((klawisze & 2) != 0 && !this.bohater.leci()) {
            this.bohater.podskocz();
        }
        if ((klawisze & 0x40) != 0) {
            if (this.bohater.mozeStrzelac()) {
                this.bohater.strzel();
            } else {
                this.bohater.laduj();
            }
        }
    }

    public Potworki getPotworki() {
        return this.potworki;
    }

    public Pociski getPociski() {
        return this.pociski;
    }

    public Bohater getBohater() {
        return this.bohater;
    }

    public void ustawDanePotworki(int x, int y, int i, DanePotworka p) {
        this.dane[x][y][i] = p;
    }

    public void ustawDanePotworkiDlugosc(int x, int y, int dlugosc) {
        this.dane[x][y] = new DanePotworka[dlugosc];
    }

    public void koniecGry() {
        this.kontynuowac = false;
        this.gra.wyswietlKomunikat("Koniec gry!");
    }

    public void run() {
        while (this.kontynuowac) {
            this.klawiatura();
            this.bohater.spadek();
            this.potworki.ruchPotworkow();
            this.pociski.ruchPociskow();
            this.paint(this.g);
            this.pociski.sprawdzPociski();
            if (this.bohater.kolizja()) {
                this.koniecGry();
            }
            if (this.bohater.dotarlDoKonca()) {
                this.kontynuowac = false;
                this.gra.wyswietlKomunikat("Zwyciestwo!!!");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean jakPostapic(int value) {
        return this.random.nextLong() % 100L < (long)value;
    }
}

