package pl.helion.j2mepp.odtwarzacz;

import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
public class OdtwarzaczMIDlet extends MIDlet implements CommandListener
{
	public OdtwarzaczMIDlet() throws Exception
	{
		menu = new List("Wybierz akcje:",Choice.IMPLICIT,OPCJE,null);
		Command wybierz = new Command("Wybierz",Command.OK,0);
		Command koniec = new Command("Koniec",Command.EXIT,0);
		Command powrot = new Command("Powrot",Command.EXIT,0);
		menu.addCommand(koniec);
		menu.addCommand(wybierz);
		menu.setSelectCommand(wybierz);
		menu.setCommandListener(this);
		formaHttp = new Form("Podaj adres URL:");
		poleUrl = new TextField("","http://",150,TextField.ANY);
		formaHttp.append(poleUrl);
		Command ok = new Command("OK",Command.OK,0);
		formaHttp.addCommand(ok);
		formaHttp.addCommand(powrot);
		formaHttp.setCommandListener(this);
		listaFile = new List("Wybierz plik:",List.IMPLICIT);
		Command wejdz = new Command("Wejdz",Command.ITEM,0);
		Command wyjdz = new Command("Wyjdz",Command.ITEM,1);
		listaFile.addCommand(wejdz);
		listaFile.addCommand(wyjdz);
		listaFile.addCommand(powrot);
		listaFile.setSelectCommand(wejdz);
		listaFile.setCommandListener(this);
		listaPrzechwytujaca = new List("Przechwyc audio",Choice.IMPLICIT,POLECENIA_PRZECHWYTYWANIA,null);
		listaPrzechwytujaca.addCommand(powrot);
		listaPrzechwytujaca.addCommand(wybierz);
		listaPrzechwytujaca.setSelectCommand(wybierz);
		listaPrzechwytujaca.setCommandListener(this);
		listaRms = new List("Wybierz element:",Choice.IMPLICIT);
		listaRms.addCommand(wybierz);
		listaRms.addCommand(powrot);
		listaRms.setSelectCommand(wybierz);
		listaRms.setCommandListener(this);
		formaOdtwarzacz = new Form("Teraz odtwarzane...");
		formaOdtwarzacz.append("");
		formaOdtwarzacz.addCommand(powrot);
		formaOdtwarzacz.setCommandListener(this);
		formaAparat = new Form("Zrob zdjecie");
		formaAparat.append("");
		Command pstryk = new Command("Pstryk!",Command.OK,0);
		formaAparat.addCommand(powrot);
		formaAparat.addCommand(pstryk);
		formaAparat.setCommandListener(this);
		odtwarzacz = new Odtwarzacz(this);
		menadzer = new MenadzerPlikow(this);
		ekran = Display.getDisplay(this);
		ekran.setCurrent(menu);
	}
	public void startApp() {}
	public void pauseApp() {}
	public void destroyApp(boolean u) 
	{
		odtwarzacz.koniec();
	}
	public void commandAction(Command c, Displayable s)
	{
		if (s == menu)
		{
			if (c.getCommandType() == Command.OK)
			{
				if (menu.getSelectedIndex() == 0)
					ekran.setCurrent(formaHttp);
				if (menu.getSelectedIndex() == 1)
				{
					menadzer.odswiez();
					menadzer.wyswietlKorzenie();
					ekran.setCurrent(listaFile);
				}
				if (menu.getSelectedIndex() == 2)
				{
					listaRms.deleteAll();
					String[] numery = odtwarzacz.pobierzID();
					for (int i=0;i<numery.length;i++)
						listaRms.append(numery[i],null);
					ekran.setCurrent(listaRms);
				}
				if (menu.getSelectedIndex() == 3)
					ekran.setCurrent(listaPrzechwytujaca);
				if (menu.getSelectedIndex() == 4)
				{
					ekran.setCurrent(formaAparat);
					Item it = odtwarzacz.pobierajObraz();
					if (it!=null)
						formaAparat.set(0,it);
				}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				this.destroyApp(true);
				this.notifyDestroyed();
			}
		}
		if (s == formaHttp)
		{
			if (c.getCommandType() == Command.OK)
				if (!poleUrl.getString().equals(""))
				{
					odtwarzacz.przygotuj(poleUrl.getString());
				}
			if (c.getCommandType() == Command.EXIT)
				ekran.setCurrent(menu);
		}
		if (s == listaFile)
		{
			if (c.getCommandType() == Command.ITEM)
			{
				try
				{
					if (c.getPriority()==0)
					{
						int k = listaFile.getSelectedIndex();
						if (k>-1)
						{
							menadzer.przejdzDo(listaFile.getString(k));
							if (menadzer.jestKatalog())
							{
								String[] wyniki = menadzer.zwrocZawartosc();
								this.wyswietlElementy(wyniki);
							} else
							{
								odtwarzacz.przygotuj(menadzer.pobierzSciezke());
							}
						}
					}
					if (c.getPriority()==1)
					{
						menadzer.wyjdzDoGory();
						String[] wyniki = menadzer.zwrocZawartosc();
						this.wyswietlElementy(wyniki);	
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				ekran.setCurrent(menu);
			}
		}
		if (s == listaRms)
		{
			if (c.getCommandType() == Command.OK)
				if (listaRms.getSelectedIndex()>-1)
					odtwarzacz.przygotuj(" rms://"+listaRms.getString(listaRms.getSelectedIndex()));
			if (c.getCommandType() == Command.EXIT)
				ekran.setCurrent(menu);
		}
		if (s == formaOdtwarzacz)
		{
			if (c.getCommandType() == Command.EXIT)
			{
				ekran.setCurrent(menu);
				odtwarzacz.przerwij();
			}
		}
		if (s == formaAparat)
		{
			if (c.getCommandType() == Command.OK)
			{
				try
				{
					odtwarzacz.pobierzZdjecie();
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				ekran.setCurrent(menu);
				odtwarzacz.przerwij();
			}
		}
		if (s == listaPrzechwytujaca)
		{
			if (c.getCommandType() == Command.OK)
			{
				if (listaPrzechwytujaca.getSelectedIndex() == 0)
					odtwarzacz.przechwyc(true);
				if (listaPrzechwytujaca.getSelectedIndex() == 1)
					odtwarzacz.przechwyc(false);
				if (listaPrzechwytujaca.getSelectedIndex() == 2)
					odtwarzacz.odtworzNagranie();
				if (listaPrzechwytujaca.getSelectedIndex() == 3)
					try
					{
						odtwarzacz.zapisz("audio/x-wav");
					}
					catch (Exception e)
					{
						e.printStackTrace();
					}
			}
			if (c.getCommandType() == Command.EXIT)
			{
				odtwarzacz.przechwyc(false);
				ekran.setCurrent(menu);
			}
		}
	}
	public void wyswietlElementy(String[] wartosci)
	{
		listaFile.deleteAll();
		for (int i=wartosci.length-1;i>=0;i--)
			listaFile.append(wartosci[i],null);
	}
	public void wlaczWyswietlacz(Item it)
	{
		if (it!=null)
			formaOdtwarzacz.set(0,it);
		else
			formaOdtwarzacz.set(0,new StringItem("",""));
		ekran.setCurrent(formaOdtwarzacz);
	}
	private Odtwarzacz odtwarzacz;
	private MenadzerPlikow menadzer;
	private List menu;
	private List listaFile;
	private List listaRms;
	private Form formaHttp;
	private Form formaAparat;
	private Form formaOdtwarzacz;
	private List listaPrzechwytujaca;
	private Display ekran;
	private TextField poleUrl;
	private final String[] POLECENIA_PRZECHWYTYWANIA = new String[]
    {"Start","Stop","Odtworz","Zapisz"};
	private final String[] OPCJE = new String[]
	{"Odtworz plik z Internetu","Odtworz plik z urzadzenia","Odtworz plik z RMS","Przechwyc audio", "Zrob zdjecie"};
}