package pl.helion.j2mepp.graplatformowa;
import javax.microedition.lcdui.game.*;
import javax.microedition.lcdui.*;
import java.io.IOException;
import java.util.Random;
public class Plotno extends GameCanvas implements Runnable, CommandListener
{
 public Plotno(boolean keys, GraPlatformowaMIDlet _gra)
 {
  super(keys);
  Command c = new Command("Koniec",Command.EXIT,0);
  this.setCommandListener(this);
  this.addCommand(c);
  gra = _gra;
  MenadzerDanych m = null;
  try
  {
   m = new MenadzerDanych("/plansza1.dat");
  }
  catch (Exception e)
  {
   this.zakonczGre();
  }
  g = this.getGraphics();
  try
  {
   tlo = new TiledLayer(m.getDuzeX(),m.getDuzeY(),Image.createImage("/full.PNG"),WYMIAR_PL,WYMIAR_PL);
   bohater = new Bohater(Image.createImage("/bohater.PNG"), m.getStartPlanszaX(), m.getStartPlanszaY(), tlo, this);
   bohater.setPosition(WYMIAR_PL*m.getPozycjaX(),WYMIAR_PL*m.getPozycjaY());
  }
  catch (IOException e)
  {
   this.zakonczGre();
  }
  SZEROKOSC = m.getSzerokosc();
  WYSOKOSC = m.getWysokosc();
  bohater.setKoniec(m.getXKoncowe(),m.getYKoncowe());
  plansza = m.getPlansza();
  dane = m.getDane();
  for (int i=0;i<m.getDuzeY();i++)
   for (int j=0;j<m.getDuzeX();j++)
    tlo.setCell(j,i,plansza[j][i]);
  menadzer = new LayerManager();
  menadzer.append(bohater);
  menadzer.append(tlo);
  menadzer.setViewWindow(0,0,SZEROKOSC,WYSOKOSC);
  pociski = new Pociski(this);
  potworki = new Potworki(this);
  odswiezMenadzera(m.getStartPlanszaX(),m.getStartPlanszaY());
  random = new Random(System.currentTimeMillis());
  Thread watek = new Thread(this);
  watek.start();
 }
 public void commandAction(Command c, Displayable s)
 {
  gra.destroyApp(true);
  gra.notifyDestroyed();
 }
 public void zakonczGre()
 {
  gra.wyswietlKomunikat("Blad wczytywania planszy");
  gra.destroyApp(true);
  gra.notifyDestroyed();
 }
 public void usunZMenadzera(Layer l)
 {
  menadzer.remove(l);
 }
 public void dodajDoMenadzera(Layer l)
 {
  menadzer.insert(l,1);
 }
 public void odswiezMenadzera(int x, int y)
 {
  menadzer.setViewWindow((x-1)*SZEROKOSC,(y-1)*WYSOKOSC,SZEROKOSC,WYSOKOSC);
  for (int i=0;i<potworki.getDlugosc();i++)
   menadzer.remove(potworki.getPotworek(i));
  DanePotworka[] aktualne = dane[x-1][y-1];
  potworki.ustawPotworki(aktualne.length);
  for (int i=0;i<aktualne.length;i++)
  {
   try
   {
    potworki.tworzPotworek(new Potworek(Image.createImage("/wrog.PNG"),x,y,tlo,WYMIAR_PL*aktualne[i].getXend(),aktualne[i].getKierunek(),this),i);
    potworki.getPotworek(i).setPosition(WYMIAR_PL*aktualne[i].getXstart(),WYMIAR_PL*(aktualne[i].getY()+1)-WYMIAR_BOH);
   } catch (IOException e){e.printStackTrace();}
  }
  pociski.usunPociski();
 }
 public void paint(Graphics g)
 {
  g.setColor(255,255,255);
  g.fillRect(0,0,tlo.getWidth(),tlo.getHeight());
  menadzer.paint(g,0,0);
  this.flushGraphics();
 }
 public void klawiatura()
 {
  int klawisze = this.getKeyStates();
  if ((klawisze & LEFT_PRESSED)!=0)
  {
   bohater.setKierunek(LEWO);
   bohater.przesunLewo(DYSTANS);
  }
  if ((klawisze & RIGHT_PRESSED)!=0)
  {
   bohater.setKierunek(PRAWO);
   bohater.przesunPrawo(DYSTANS);
  }
  if ((klawisze & UP_PRESSED)!=0)
  {
   if (!bohater.leci()) bohater.podskocz();
  }
  if ((klawisze & DOWN_PRESSED)!=0)
  {
   if (bohater.mozeStrzelac())
   {
    bohater.strzel();
   } else bohater.laduj();
  }
 }
 public Potworki getPotworki()
 {
  return potworki;
 }
 public Pociski getPociski()
 {
  return pociski;
 }
 public Bohater getBohater()
 {
  return bohater; 
 }
 public void ustawDanePotworki(int x, int y, int i, DanePotworka p)
 {
  dane[x][y][i] = p;
 }
 public void ustawDanePotworkiDlugosc(int x,int y,int dlugosc)
 {
  dane[x][y] = new DanePotworka[dlugosc];
 }
 public void koniecGry()
 {
  kontynuowac = false;
  gra.wyswietlKomunikat("Koniec gry!");
 }
 public void run()
 {
  while (kontynuowac)
  {
   this.klawiatura();
   bohater.spadek();
   potworki.ruchPotworkow();
   pociski.ruchPociskow();
   this.paint(g);
   pociski.sprawdzPociski();
   if (bohater.kolizja())
   {
    this.koniecGry();
   }
   if (bohater.dotarlDoKonca())
   {
    kontynuowac = false;
    gra.wyswietlKomunikat("Zwyciestwo!!!");
   }
   try
   {
    Thread.sleep(PRZERWA);
   }
   catch (InterruptedException e){}
  }
 }
 public boolean jakPostapic(int value)
 {
  return (random.nextLong() % 100 < value);
 }
 private short[][] plansza;
 private DanePotworka[][][] dane;
 private GraPlatformowaMIDlet gra;
 private TiledLayer tlo;
 private Graphics g;
 private Bohater bohater;
 private LayerManager menadzer;
 private Pociski pociski;
 private Random random;
 private boolean kontynuowac = true;
 public static int SZEROKOSC;
 public static int WYSOKOSC;
 private Potworki potworki;
 public static final int PRZERWA = 50;
 public static final int DYSTANS = 2;
 public static final int DYSTANSPOCISK = 4;
 public static final int ENERGIA = 16;
 public static final int WYMIAR_PL = 16;
 public static final int WYMIAR_BOH = 10;
 public static final boolean PRAWO = true;
 public static final boolean LEWO = false;
}
