/*
 * Decompiled with CFR 0.152.
 */
package com.rychlickikicior.kitijdb;

import com.rychlickikicior.kitijdb.Descriptor;
import com.rychlickikicior.kitijdb.PrimaryKey;
import com.rychlickikicior.kitijdb.Query;
import com.rychlickikicior.kitijdb.QueryData;
import com.rychlickikicior.kitijdb.QueryType;
import com.rychlickikicior.kitijdb.ReflectionHandler;
import com.rychlickikicior.kitijdb.SettingsReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBManager {
    private QueryData queryData;
    private Properties properties;
    private Connection connection;
    private ReflectionHandler reflectionHandler = new ReflectionHandler();
    private static DBManager _instance;

    private DBManager() {
    }

    private void connect() throws SQLException, ClassNotFoundException {
        String url = this.properties.getProperty("jdbcUrl").toString();
        Class.forName(this.properties.getProperty("driverClass").toString());
        this.connection = DriverManager.getConnection(url);
    }

    public <T> List<T> selectRelated(Class<T> type, String queryName, Object ... params) {
        Descriptor descriptor = this.queryData.get(type);
        Query q = descriptor.findQuery(queryName, QueryType.SELECT);
        try {
            int counter = 0;
            for (String param : q.getParameterNames()) {
                q.setParameter(param, params[counter]);
                ++counter;
            }
            PreparedStatement statement = this.connection.prepareStatement(q.prepare());
            q.fillValues(statement);
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<T> results = new ArrayList<T>();
            while (resultSet.next()) {
                Method setter;
                T result = type.newInstance();
                HashMap childrenOfEntity = new HashMap();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    String columnName = metaData.getColumnLabel(i + 1);
                    String[] fieldParts = columnName.split("_");
                    if (fieldParts.length == 1) {
                        setter = this.reflectionHandler.getBeanSetMethod(type, columnName);
                        setter.invoke(result, resultSet.getObject(i + 1));
                        continue;
                    }
                    String table = fieldParts[0];
                    String childColumnName = fieldParts[1];
                    Class elementClass = descriptor.getClassByValue(table);
                    if (elementClass == null) continue;
                    Object happyChild = childrenOfEntity.get(table);
                    if (happyChild == null) {
                        happyChild = elementClass.newInstance();
                        childrenOfEntity.put(table, happyChild);
                    }
                    Method setter2 = this.reflectionHandler.getBeanSetMethod(elementClass, childColumnName);
                    setter2.invoke(happyChild, resultSet.getObject(i + 1));
                }
                if (results.contains(result)) {
                    Object original = results.get(results.indexOf(result));
                    for (Class childClass : descriptor.getChildClasses()) {
                        Object toAdd;
                        String propertyName = descriptor.getChild(childClass);
                        Method getter = this.reflectionHandler.getBeanReadMethod(type, propertyName);
                        Collection children = (Collection)getter.invoke(original, new Object[0]);
                        if (children.contains(toAdd = childrenOfEntity.get(propertyName))) continue;
                        children.add(toAdd);
                    }
                    continue;
                }
                for (Class childClass : descriptor.getChildClasses()) {
                    String propertyName = descriptor.getChild(childClass);
                    setter = this.reflectionHandler.getBeanSetMethod(type, propertyName);
                    Collection c = (Collection)descriptor.getPropertyType(childClass).newInstance();
                    c.add(childrenOfEntity.get(propertyName));
                    setter.invoke(result, c);
                }
                results.add(result);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T select(Class<T> type, int key) {
        return this.select(type, new PrimaryKey(key));
    }

    public <T> T select(Class<T> type, PrimaryKey key) {
        List<T> list = this.select(type, "default", key.getKey());
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> select(Class<T> type, String queryName, Object ... params) {
        Descriptor descriptor = this.queryData.get(type);
        Query q = descriptor.findQuery(queryName, QueryType.SELECT);
        try {
            int counter = 0;
            for (String param : q.getParameterNames()) {
                q.setParameter(param, params[counter]);
                ++counter;
            }
            PreparedStatement statement = this.connection.prepareStatement(q.prepare());
            q.fillValues(statement);
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<T> results = new ArrayList<T>();
            while (resultSet.next()) {
                T result = type.newInstance();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    String columnName = metaData.getColumnName(i + 1);
                    Method setter = this.reflectionHandler.getBeanSetMethod(type, columnName);
                    setter.invoke(result, resultSet.getObject(i + 1));
                }
                results.add(result);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List selectGeneric(Class c, String queryName, Object ... params) {
        Descriptor descriptor = this.queryData.get(c);
        Query q = descriptor.findQuery(queryName, QueryType.SELECT);
        int counter = 0;
        for (String param : q.getParameterNames()) {
            q.setParameter(param, params[counter]);
            ++counter;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            PreparedStatement statement = this.connection.prepareStatement(q.prepare());
            q.fillValues(statement);
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            if (resultSet.last()) {
                if (resultSet.getRow() == 1) {
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        result.add(resultSet.getObject(i + 1));
                    }
                    return result;
                }
                resultSet.first();
                do {
                    ArrayList<Object> record = new ArrayList<Object>();
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        record.add(resultSet.getObject(i + 1));
                    }
                    result.add(record);
                } while (resultSet.next());
                return result;
            }
            return result;
        }
        catch (SQLException se) {
            se.printStackTrace();
            return result;
        }
    }

    public Object insert(Object entity) {
        Class c = entity.getClass();
        LinkedList<Class> list = new LinkedList<Class>();
        list.add(c);
        while ((c = c.getSuperclass()) != null && c != Object.class) {
            list.add(c);
        }
        Class ultimateParent = (Class)list.removeLast();
        PrimaryKey keyToUse = this.insert(entity, ultimateParent);
        if (keyToUse == null) {
            return null;
        }
        while (!list.isEmpty()) {
            c = (Class)list.removeLast();
            Object[] values = this.getValuesOfClass(entity, c);
            ArrayList<Object> args = new ArrayList<Object>();
            args.addAll(Arrays.asList(keyToUse.getKey()));
            args.addAll(Arrays.asList(values));
            if (this.modify(c, QueryType.INSERT, "default", args.toArray()) > 0) continue;
            this.delete(ultimateParent, keyToUse);
            return null;
        }
        if (keyToUse != null) {
            return this.select(entity.getClass(), keyToUse);
        }
        return entity;
    }

    private Object[] getValuesOfClass(Object entity, Class c) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            try {
                list.add(m.invoke(entity, new Object[0]));
            }
            catch (Exception iae) {
                iae.printStackTrace();
            }
        }
        return list.toArray();
    }

    private PrimaryKey insert(Object entity, Class entityClass) {
        Descriptor descriptor = this.queryData.get(entityClass);
        Query q = descriptor.findQuery("default", QueryType.INSERT);
        try {
            for (String param : q.getParameterNames()) {
                Method getter = this.reflectionHandler.getBeanReadMethod(entityClass, param);
                q.setParameter(param, getter.invoke(entity, new Object[0]));
            }
            PreparedStatement statement = this.connection.prepareStatement(q.prepare(), 1);
            q.fillValues(statement);
            int result = statement.executeUpdate();
            ResultSet rs = statement.getGeneratedKeys();
            ResultSetMetaData metaData = rs.getMetaData();
            PrimaryKey keyOut = null;
            if (rs.next()) {
                Object[] key = new Object[metaData.getColumnCount()];
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    key[i] = rs.getObject(i + 1);
                }
                keyOut = new PrimaryKey(new Object[0]);
                keyOut.setKey(key);
            } else {
                keyOut = this.resolvePrimaryKey(entity);
            }
            return keyOut;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int update(Object entity) {
        return this.update(entity, true);
    }

    private int update(Object entity, boolean doTransaction) {
        Class basicClass = entity.getClass();
        Descriptor d = this.queryData.get(basicClass);
        int suma = 0;
        try {
            LinkedList<Class> list = new LinkedList<Class>();
            list.add(basicClass);
            Class c = basicClass;
            while ((c = c.getSuperclass()) != null && c != Object.class) {
                list.add(c);
            }
            Descriptor eldest = this.queryData.get((Class)list.get(list.size() - 1));
            if (doTransaction && eldest.isVersion()) {
                this.connection.setAutoCommit(false);
                PrimaryKey key = this.resolvePrimaryKey(entity);
                Object o = this.select(basicClass, key);
                int verNew = this.resolveVersion(o);
                int verOld = this.resolveVersion(entity);
                if (verNew != verOld) {
                    this.connection.setAutoCommit(true);
                    return 0;
                }
                this.incrementVersion(entity, verOld + 1);
            }
            while (!list.isEmpty()) {
                c = (Class)list.removeLast();
                suma += this.update(entity, c);
            }
            if (doTransaction && eldest.isVersion()) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return suma;
    }

    private PrimaryKey resolvePrimaryKey(Object entity) {
        Class<?> c = entity.getClass();
        Descriptor d = this.queryData.get(c);
        Query q = d.findQuery("default", QueryType.SELECT);
        Collection<String> params = q.getParameterNames();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String s : params) {
            Method m = this.reflectionHandler.getBeanReadMethod(c, s);
            try {
                values.add(m.invoke(entity, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PrimaryKey result = new PrimaryKey(values.toArray());
        return result;
    }

    private int resolveVersion(Object o) {
        try {
            Method m = o.getClass().getMethod("getDbversion", new Class[0]);
            return Integer.parseInt(m.invoke(o, new Object[0]).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void incrementVersion(Object o, Integer value) {
        try {
            Method m = this.reflectionHandler.getBeanSetMethod(o.getClass(), "dbversion");
            m.invoke(o, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int update(Object entity, Class entityClass) {
        Descriptor descriptor = this.queryData.get(entityClass);
        Query q = descriptor.findQuery("default", QueryType.UPDATE);
        if (q != null) {
            try {
                for (String param : q.getParameterNames()) {
                    Method getter = this.reflectionHandler.getBeanReadMethod(entityClass, param);
                    q.setParameter(param, getter.invoke(entity, new Object[0]));
                }
                PreparedStatement statement = this.connection.prepareStatement(q.prepare());
                q.fillValues(statement);
                return statement.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public int modify(Class type, QueryType queryType, String queryName, Object ... params) {
        Descriptor descriptor = this.queryData.get(type);
        Query q = descriptor.findQuery(queryName, queryType);
        try {
            int counter = 0;
            for (String param : q.getParameterNames()) {
                q.setParameter(param, params[counter]);
                ++counter;
            }
            PreparedStatement statement = this.connection.prepareStatement(q.prepare());
            q.fillValues(statement);
            return statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.MIN_VALUE;
        }
    }

    public int delete(Class type, PrimaryKey key) {
        Class c;
        for (c = type; c != null && c.getSuperclass() != Object.class; c = c.getSuperclass()) {
        }
        Descriptor descriptor = this.queryData.get(c);
        Query q = descriptor.findQuery("default", QueryType.DELETE);
        try {
            Object[] keyValues = key.getKey();
            int counter = 0;
            for (String param : q.getParameterNames()) {
                q.setParameter(param, keyValues[counter]);
                ++counter;
            }
            PreparedStatement statement = this.connection.prepareStatement(q.prepare());
            q.fillValues(statement);
            return statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public <T> int delete(Class<T> type, int key) {
        return this.delete(type, new PrimaryKey(key));
    }

    public static synchronized DBManager createManager(InputStream is) {
        if (_instance != null) {
            return _instance;
        }
        try {
            SettingsReader reader = SettingsReader.createReader(SettingsReader.SettingsType.XML, is);
            DBManager dbManager = new DBManager();
            dbManager.setProperties(reader.getProperties());
            dbManager.setQueryData(reader.getQueryData());
            dbManager.connect();
            _instance = dbManager;
            return _instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized DBManager createManager(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            DBManager manager = DBManager.createManager(fis);
            fis.close();
            return manager;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized DBManager createManager(InputStream is, String jdbcUrl) {
        DBManager manager = DBManager.createManager(is);
        manager.getProperties().setProperty("jdbc_url", jdbcUrl);
        return manager;
    }

    public int multiInsert(List entities) {
        int sum = 0;
        try {
            this.connection.setAutoCommit(false);
            for (Object entity : entities) {
                this.insert(entity);
                ++sum;
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sum;
    }

    public int multiUpdate(List entities) {
        int sum = 0;
        try {
            this.connection.setAutoCommit(false);
            for (Object entity : entities) {
                this.update(entity, false);
                ++sum;
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sum;
    }

    private QueryData getQueryData() {
        return this.queryData;
    }

    private void setQueryData(QueryData queryData) {
        this.queryData = queryData;
    }

    private Properties getProperties() {
        return this.properties;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }
}

