package helion.rozdzial6;

import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;


public class RankingMIDlet extends MIDlet
                        implements CommandListener, Runnable {

    private Command exitCommand;
    private Command okCommand;
    private Command cancelCommand;
    private Command newCommand;
    private Display display;
    private TextField isbnField;
    private StringItem isbnDisplay;
    private StringItem titleDisplay;
    private StringItem rankingDisplay;
    private StringItem reviewDisplay;
    private Form isbnForm;
    private Form searchForm;
    private Form resultForm;
    private BookInfo searchBookInfo;
    private Thread searchThread;

    protected void startApp() throws MIDletStateChangeException {
        if (display == null) {
            initialize();
            display.setCurrent(isbnForm);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional)
                        throws MIDletStateChangeException {

    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == exitCommand) {
            try {
                destroyApp(true);
            } catch (MIDletStateChangeException ex) {
            }
            notifyDestroyed();
        } else if (cmd == okCommand) {
            String isbn = isbnField.getString().trim();
            if (!isbn.equals("")) {
                searchForBook(new BookInfo(isbn));
            }
        } else if (cmd == cancelCommand) {
            searchThread = null;
            isbnField.setString(null);
            display.setCurrent(isbnForm);
        } else if (cmd == newCommand) {
            isbnField.setString(null);
            display.setCurrent(isbnForm);
        }
    }

    public void searchForBook(BookInfo info) {
        searchBookInfo = info;
        isbnDisplay.setText(info.getIsbn().trim());
        display.setCurrent(searchForm);
        searchThread = new Thread(this);
        searchThread.start();
    }

    public void run() {
        try {
            boolean found = Fetcher.fetch(searchBookInfo);
            if (searchThread == Thread.currentThread()) {
                if (found && searchBookInfo.getTitle() != null) {
                    titleDisplay.setText(searchBookInfo.getTitle());
                    rankingDisplay.setText(
                        searchBookInfo.getRanking() == 0 ? "" :
                                String.valueOf(searchBookInfo.getRanking()));
                    reviewDisplay.setText(
                        searchBookInfo.getReviews() == 0 ? "" :
                                String.valueOf(searchBookInfo.getReviews()));
                    display.setCurrent(resultForm);
                } else {
                    Alert alert = new Alert("Nie znaleziono", null,
                                       null, AlertType.ERROR);
                    alert.setTimeout(Alert.FOREVER);
                    alert.setString("Nie znaleziono ksiazki o numerze ISBN " +
                                       searchBookInfo.getIsbn());
                    isbnField.setString(null);
                    display.setCurrent(alert, isbnForm);
                }
            }
        } catch (Throwable ex) {
            if (searchThread == Thread.currentThread()) {
                Alert alert = new Alert("Poszukiwanie nieudane", null,
                                        null, AlertType.ERROR);
                alert.setTimeout(Alert.FOREVER);
                alert.setString("Poszukiwanie nieudane:\n" + ex.getMessage());
                isbnField.setString(null);
                display.setCurrent(alert, getSelectionScreen());
            }
        }
    }

    private void initialize() {
        display = Display.getDisplay(this);

        exitCommand = new Command("Exit", Command.EXIT, 0);
        okCommand = new Command("OK", Command.OK, 0);
        cancelCommand = new Command("Anuluj", Command.CANCEL, 0);
        newCommand = new Command("Nowa", Command.SCREEN, 1);

        isbnForm = new Form("Book Query");
        isbnForm.append("Enter an ISBN and press OK:");
        isbnField = new TextField("", null, 10, TextField.ANY);
        isbnForm.append(isbnField);
        isbnForm.addCommand(okCommand);
        isbnForm.addCommand(exitCommand);

        isbnForm = new Form("Szukanie ksiazek");
        isbnForm.append("Wprowadz numer ISBN i nacisnij OK:");
        isbnDisplay = new StringItem(null, null);
        searchForm.append(isbnDisplay);
        searchForm.append("\nProsze czekac....");
        searchForm.addCommand(cancelCommand);

        resultForm = new Form("Wynik poszukiwan");
        titleDisplay = new StringItem("Tytul ksiazki: ", null);
        rankingDisplay = new StringItem("Pozycja w rankingu:    ", null);
        reviewDisplay = new StringItem("Liczba recenzji:    ", null);

        resultForm.append(titleDisplay);
        resultForm.append(rankingDisplay);
        resultForm.append(reviewDisplay);
        resultForm.addCommand(newCommand);
        resultForm.addCommand(exitCommand);

        // Obslugujemy zdarzenia zachodzace na wszystkich formularzach
        isbnForm.setCommandListener(this);
        searchForm.setCommandListener(this);
        resultForm.setCommandListener(this);
    }
}