package helion.rozdzial6;

/**
 * Klasa kodujaca wartosci przekazywane w parametrach adresow URL
 * do postaci zrozumialej przez urzadzenia MIDP.
 */
public class EncodeURL {

    // Znaki, ktorych nie trzeba konwertowac
    private static final String noEncode =
        "abcdefghijklmnopqrstuvwxyz" +
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ" +
        "0123456789.*-_";

    // Mapowanie wartosci od 0 do 15 na
    // odpowiadajace im znaki szesnastkowe.
    private static final char[] hexDigits = {
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
    };

    // Koduje podany ciag znakow zgodnie z wymaganiami odnosnie
    // zapytan umieszczany w adresach URL i przekazywanych metoda POST.
    public static String encode(String src) {
        StringBuffer result = new StringBuffer(src.length());
        int count = src.length();
        for (int i = 0; i < count; i++) {
            char c = src.charAt(i);
            if (noEncode.indexOf(c) != -1) {
                // To znak, ktorego nie trzeba kodowac
                result.append(c);
                continue;
            }

            // Spacja zamieniana jest na '+'
            if (c == ' ') {
                result.append('+');
                continue;
            }

            // Pozostale znaki musza byc przekonwertowane na
            // '%XY', gdzie 'XY' jest szesnastkowa wartoscia
            // danego znaku.
            result.append('%');
            result.append(hexDigits[(c >> 4) & 0xF]);
            result.append(hexDigits[c & 0xF]);
        }
        return result.toString();
    }
}