package helion.rozdzial6;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class DatagramReceiver {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Sposob uzycia: DatagramReceiver port");
            System.exit(1);
        }

        try {
            DatagramConnection receiver =
                    (DatagramConnection)Connector.open("datagram://:" + args[0]);
            byte[] buffer = new byte[256];
            Datagram dgram = receiver.newDatagram(buffer, buffer.length);
            for (;;) {
                dgram.setLength(buffer.length);
                receiver.receive(dgram);
                int length = dgram.getLength();
                System.out.println("Odebrano datagram. Wartosc pola length wynosi " + length);

                // Pokaz zawartosc datagramu.
                for (int i = 0; i < length; i++) {
                    System.out.print(buffer[i] + " ");
                }
                System.out.println();

                // Odeslij odpowiedz
                receiver.send(dgram);
            }
        } catch (IOException ex) {
            System.out.println("IOException: " + ex);
        }
    }
}