package helion.rozdzial6;

import java.io.InputStream;
import java.io.IOException;

/**
 * Klasa reprezentujaca informacje
 * o danej ksiazce, wsrod ktorych znajduje sie
 * liczba jej rezencji i jej pozycja w rankingu sprzedazy.
 */
public class BookInfo {

    int    id;          // Zmienna wykorzystywana przy zapisywaniu informacji w pamieci nieulotnej
    String isbn;        // Numer ISBN ksiazki
    String title;       // Tytul ksiazki
    int    reviews;     // Liczba recenzji
    int    ranking;     // Aktualne miejsce w rankingu
    int    lastReviews; // Ostatnia liczba recenzji
    int    lastRanking;  // Ostatnia pozycja w rankingu

    public BookInfo(String isbn) {
        this.isbn = isbn;
    }

    public String getIsbn() {
        return isbn;
    }

    public String getTitle() {
        return title;
    }

    public int getReviews() {
        return reviews;
    }

    public int getRanking() {
        return ranking;
    }

    public int getLastReviews() {
        return lastReviews;
    }

    public int getLastRanking() {
        return lastRanking;
    }

    // Zapisuje szczegolowe informacje pobrane ze strumienia wejsciowego
    public void setFromInputStream(InputStream is) {
        // Przeszukaj dane wejsciowe za pomoca obiektu InputHelper
        InputHelper helper = new InputHelper(is);
        try {

            // Nadaj zmiennym wartosci biezace
            int newRanking = this.ranking;
            int newReviews = this.reviews;

            boolean found = helper.moveAfterString("buying info: ");
            if (!found) {
                return;
            }

            // Pobierz tytul z pozostalej czesci tego wiersza
            StringBuffer titleBuffer = helper.getRestOfLine();

            // Sprawdz liczbe recenzji
            found = helper.moveAfterString("Based on ");
            if (!found) {
                return;
            }

            // Pobierz liczbe recenzji z biezacej lokalizacji
            String reviewString = helper.gatherNumber();

            // Sprawdz pozycje w rankingu sprzedazy
            found = helper.moveAfterString("Sales Rank: ");
            if (!found) {
                return;
            }

            // Odczytaj liczbe z biezacej lokalizacji
            String rankingString = helper.gatherNumber();

            // Po odnalezieniu wszystkich informacji ustaw nowy tytul
            title = titleBuffer.toString().trim();

            // Teraz przeksztalc liczbe recenzji i pozycje w rankingu na
            // wartosci calkowite. Jezeli to sie nie uda, zostaw je tak jak sa.
            try {
                newRanking = Integer.parseInt(rankingString);
            } catch (NumberFormatException ex) {
            }

            if (newRanking != ranking) {
                lastRanking = ranking;
                ranking = newRanking;
                if (lastRanking == 0) {
                    // Za pierwszym razem nadaj ostatniej i biezacej
                    // pozycji te sama wartosc
                    lastRanking = ranking;
                }
            }

            try {
                newReviews = Integer.parseInt(reviewString);
            } catch (NumberFormatException ex) {
            }

            if (newReviews != reviews) {
                lastReviews = reviews;
                reviews = newReviews;
                if (lastReviews == 0) {
                    // Za pierwszym razem nadaj ostatniej i biezacej
                    // pozycji te sama wartosc
                    lastReviews = reviews;
                }
            }
        } catch (IOException ex) {
        } finally {
            // Pozwol na zwolnienie pamieci przez garbage collector
            helper.dispose();
            helper = null;
        }
    }
}