package helion.rozdzial5;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class ZdarzeniaMIDlet extends MIDlet 
                        implements CommandListener {

    // Obiekt klasy Display biezacego MIDletu
    private Display ekran;
        
    // Znacznik wskazujacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieKoniec;
    
    protected void startApp() {
        if (!uruchomiony) {
            ekran = Display.getDisplay(this);
            Canvas kanwa = new ZdarzeniaCanvas();            
            polecenieKoniec = new Command("Koniec", Command.EXIT, 0);
            kanwa.addCommand(polecenieKoniec);
            kanwa.setCommandListener(this);
            ekran.setCurrent(kanwa);

            uruchomiony = true;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == polecenieKoniec) {
            // Koniec. Nie ma potrzeby wywolywania destroyApp
            // poniewaz jest pusta.
            notifyDestroyed();
        }
    }     
}

class ZdarzeniaCanvas extends Canvas {
    
    static int[] kodyKlawiszy = {KEY_NUM0, KEY_NUM1, KEY_NUM2, KEY_NUM3, KEY_NUM4,
                             KEY_NUM5, KEY_NUM6, KEY_NUM7, KEY_NUM8, KEY_NUM9,
                             KEY_POUND, KEY_STAR};
    static String[] nazwyKlawiszy = {"KEY_NUM0", "KEY_NUM1", "KEY_NUM2", "KEY_NUM3", "KEY_NUM4",
                             "KEY_NUM5", "KEY_NUM6", "KEY_NUM7", "KEY_NUM8", "KEY_NUM9",
                             "KEY_POUND", "KEY_STAR"};
                             
    static int[] akcjeGier = {
                            UP, DOWN, LEFT, RIGHT, FIRE,
                            GAME_A, GAME_B, GAME_C, GAME_D};
    static String[] nazwyDlaGier = {
                            "UP", "DOWN", "LEFT", "RIGHT", "FIRE",
                            "GAME_A", "GAME_B", "GAME_C", "GAME_D" };

    
    int ostKodKlaw = 0;
    
    int ostX;
    
    int ostY;
    
    boolean wskaznik;

    protected void keyPressed(int kodKlawisza) {
        ostKodKlaw = kodKlawisza;
        repaint();
    }
        
    protected void keyRepeated(int kodKlawisza) {
        ostKodKlaw = kodKlawisza;
        repaint();
    }
        
    protected void keyReleased(int kodKlawisza) {
        ostKodKlaw = 0;
        repaint();
    }    

    protected void pointerPressed(int x, int y) {
        ostX = x;
        ostY = y;
        wskaznik = true;
        repaint();
    }
        
    protected void pointerDragged(int x, int y) {
        ostX = x;
        ostY = y;
        wskaznik = true;
        repaint();
    }
    
    protected void pointerReleased(int x, int y) {
        wskaznik = false;
        repaint();
    }
    
    protected void paint(Graphics g) {
        g.setColor(0xffffff);
        g.fillRect(0, 0, getWidth(), getHeight());
        
        g.setColor(0);
        if (ostKodKlaw != 0) {
            String tekstKlaw = "Kod klawisza " + ostKodKlaw;
            String nazwaKlaw = null;

            // Sprawdzenie, czy jest to klawisz standardowy
            for (int i = 0; i < kodyKlawiszy.length; i++) {
                if (ostKodKlaw == kodyKlawiszy[i]) {
                    nazwaKlaw = nazwyKlawiszy[i];
                    break;
                }
            }   
            
            if (nazwaKlaw == null) {
                // Sprawdzenie, czy jest to akcja gier
                for (int i = 0; i < akcjeGier.length; i++) {
                    if (ostKodKlaw == getKeyCode(akcjeGier[i])) {
                        nazwaKlaw = nazwyDlaGier[i];
                        break;
                    }
                }
            }
            
            g.drawString(tekstKlaw, getWidth()/2, getHeight()/2, 
                            Graphics.BASELINE|Graphics.HCENTER);
                    
            if (nazwaKlaw != null) {
                g.drawString(nazwaKlaw, getWidth()/2, getHeight()/2 + g.getFont().getHeight(), 
                            Graphics.BASELINE|Graphics.HCENTER);    
            }
        } else if (wskaznik) {
            g.drawString("(" + ostX + ", " + ostY + ")", getWidth()/2, getHeight()/2, 
                            Graphics.BASELINE|Graphics.HCENTER);
        }
    }
}