package helion.rozdzial5;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class RysunekMIDlet extends MIDlet implements CommandListener {

    // Obiekt klasy Display biezacego MIDletu
    private Display ekran;
    
    // Znacznik wskazujacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieKoniec;
    
    // Polecenie powrotu do poprzedniego ekranu
    private Command polecenieWstecz;
    
    // Lista wyboru przykladow
    private List listaPrzyklady;
    
    // Klasy demonstrujace poszczegolne problemy
    private Canvas[] kanwy;
    
    // Nazwy przykladow. Uzyte do wypelnienia listy.
    private String[] przyklady = {
        "Metoda DrawImage", "Metoda ImageGraphics"
    };

    protected void startApp() {
        if (!uruchomiony) {
            uruchomiony = true;
            ekran = Display.getDisplay(this);
            
            // Tworzenie wspolnych polecen
            tworzPolecenia();
            
            // Tworzenie kanw
            tworzKanwy();
            
            // Tworzenie listy przykladow
            tworzListe();
            
            // Rozpoczecie od wyswietlenia listy
            ekran.setCurrent(listaPrzyklady);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == listaPrzyklady) {
            // Wybrano nowy przyklad
            int indeks = listaPrzyklady.getSelectedIndex();
            ekran.setCurrent(kanwy[indeks]);
        } else if (c == polecenieKoniec) {
            // Koniec. Nie ma potrzeby wywolywania destroyApp
            // poniewaz jest pusta.
            notifyDestroyed();
        } else if (c == polecenieWstecz) {
            // Powrot do glownej listy wyboru
            ekran.setCurrent(listaPrzyklady);
        }
    }
    
    private void tworzPolecenia() {
        polecenieKoniec = new Command("Koniec", Command.EXIT, 0);
        polecenieWstecz = new Command("Wstecz", Command.BACK, 1);
    }
    
    private void tworzListe() {
        listaPrzyklady = new List("Wybor przykladu", List.IMPLICIT);
        for (int i = 0; i < przyklady.length; i++) {
            listaPrzyklady.append(przyklady[i], null);
        } 
        listaPrzyklady.setCommandListener(this);
    }
    
    private void tworzKanwy() {
        kanwy = new Canvas[przyklady.length];
        kanwy[0] = tworzCanvasDrawImage();
        kanwy[1] = tworzCanvasImageGraphics();
    }

    private void addCommands(Displayable d) {
        d.addCommand(polecenieKoniec);
        d.addCommand(polecenieWstecz);
        d.setCommandListener(this);
    }
    
    // Tworzenie obiektu Canvas dla przykladu rysowania obrazu
    private Canvas tworzCanvasDrawImage() {
        Canvas kanwa = new DrawImageCanvas();
        addCommands(kanwa);
        return kanwa;
    } 
    
    // Create the Canvas to demonstrate drawing to an Image
    private Canvas tworzCanvasImageGraphics() {
        Canvas kanwa = new ImageGraphicsCanvas();
        addCommands(kanwa);
        return kanwa;
    } 
}

// Ilustracja wykorzystania metody drawImage
class DrawImageCanvas extends Canvas {
    static Image rysunek;
    
    int ilosc;
    
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Wypelnij tlo na czarno
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);
        
        // Zaladowanie rysunku z zasobu MIDletu
        if (rysunek == null) {
            try {
                rysunek = Image.createImage("/helion/rozdzial5/zasoby/ziemia.png");
            } catch (IOException ex) {
                g.setColor(0xffffff);
                g.drawString("Nieudane ladowanie rysunku!", 0, 0, Graphics.TOP | Graphics.LEFT);
                return;
            }
        }
        
        switch (ilosc % 3) {
        case 0:
            // Rysowanie obrazu w gornym lewym rogu ekranu
            g.drawImage(rysunek, 0, 0, Graphics.TOP | Graphics.LEFT);
            break;

        case 1:
            // Rysowanie obrazu w prawym dolnym rogu ekranu
            g.drawImage(rysunek, szerokosc, wysokosc, Graphics.BOTTOM | Graphics.RIGHT);
            break;
        case 2:
            // Rysowanie obrazu na srodku ekranu
            g.drawImage(rysunek, szerokosc/2, wysokosc/2, Graphics.VCENTER | Graphics.HCENTER);
        }
        ilosc++;
    }
}

// Przyklad rysowania po obrazie
class ImageGraphicsCanvas extends Canvas {
    
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworzenie obiektu Image o takiej samej wielkosci co
        // Canvas.
        Image rysunek = Image.createImage(szerokosc, wysokosc);
        Graphics grafika = rysunek.getGraphics();

        // wypelnienie tla czarnym kolorem
        grafika.fillRect(0, 0, szerokosc, wysokosc);

        // Rysowanie wzoru z linii
        int ilosc = 10;
        int krokY = wysokosc/ilosc;
        int krokX = szerokosc/ilosc;
        for (int i = 0, x = krokX, y = 0; i < ilosc; i++) {
            grafika.setColor(0xC0 + ((128 + 10 * i) << 8) + ((128 + 10 * i) << 16));
            grafika.drawLine(0, y, x, wysokosc);
            y += krokY;
            x += krokX;
        }

        // Dodanie tekstu
        grafika.setFont(Font.getFont(Font.FACE_PROPORTIONAL,
                                Font.STYLE_UNDERLINED, Font.SIZE_SMALL));
        grafika.setColor(0xffff00);
        grafika.drawString("Obraz graficzny", szerokosc/2, 0, Graphics.TOP | Graphics.HCENTER);

        // Kopiowanie obrazu na ekran
        g.drawImage(rysunek, 0, 0, Graphics.TOP | Graphics.LEFT);
    }
}