package helion.rozdzial5;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class GrafikaMIDlet extends MIDlet implements CommandListener {

    // Obiekt klasy Display biezacego MIDletu
    private Display ekran;
        
    // Znacznik wskazujacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieKoniec;
    
    // Polecenie powrotu do poprzedniego ekranu
    private Command polecenieWstecz;
    
    // Lista wyboru przykladow
    private List listaPrzyklad;
    
    // Klasy demonstrujace poszczegolne problemy
    private Canvas[] kanwy;
    
    // Nazwy przykladow. Uzyte do wypelnienia listy.
    private String[] przyklady = {
        "Linie", "Prostokaty", "Wypeln.Prostokaty",
        "Luki", "Wypeln.Luki", "Tekst"
    };

    protected void startApp() {
        if (!uruchomiony) {
            uruchomiony = true;
            ekran = Display.getDisplay(this);
            
            // Tworzenie wspolnych polecen
            tworzPolecenia();
            
            // Tworzenie kanw
            tworzKanwy();
            
            // Tworzenie listy przykladow
            tworzListe();
            
            // Rozpoczecie od wyswietlenia listy
            ekran.setCurrent(listaPrzyklad);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == listaPrzyklad) {
            // Wybrano nowy przyklad
            int indeks = listaPrzyklad.getSelectedIndex();
            ekran.setCurrent(kanwy[indeks]);
        } else if (c == polecenieKoniec) {
            // Koniec. Nie ma potrzeby wywolywania destroyApp
            // poniewaz jest pusta.
            notifyDestroyed();
        } else if (c == polecenieWstecz) {
            // Powrot do glownej listy wyboru
            ekran.setCurrent(listaPrzyklad);
        }
    }
    
    private void tworzPolecenia() {
        polecenieKoniec = new Command("Koniec", Command.EXIT, 0);
        polecenieWstecz = new Command("Wstecz", Command.BACK, 1);
    }
    
    private void tworzListe() {
        listaPrzyklad = new List("Wybor przykladu", List.IMPLICIT);
        for (int i = 0; i < przyklady.length; i++) {
            listaPrzyklad.append(przyklady[i], null);
        } 
        listaPrzyklad.setCommandListener(this);
    }
    
    private void tworzKanwy() {
        kanwy = new Canvas[przyklady.length];
        kanwy[0] = tworzCanvasLinie();
        kanwy[1] = tworzCanvasProstokat();
        kanwy[2] = tworzCanvasWypelnProstokat();
        kanwy[3] = tworzCanvasLuki();
        kanwy[4] = tworzCanvasWypLuki();
        kanwy[5] = tworzCanvasTekst();
        
    }

    private void dodajPolecenia(Displayable d) {
        d.addCommand(polecenieKoniec);
        d.addCommand(polecenieWstecz);
        d.setCommandListener(this);
    }
    
    // Tworzenie obiektu Canvas dla przykladu rysowania linii
    private Canvas tworzCanvasLinie() {
        Canvas kanwa = new CanvasLinie();
        dodajPolecenia(kanwa);
        return kanwa;
    }    
        
    // Tworzenie obiektu Canvas dla przykladu rysowania prostokatow
    private Canvas tworzCanvasProstokat() {
        Canvas kanwa = new CanvasProstokat();
        dodajPolecenia(kanwa);
        return kanwa;
    }
        
    // Tworzenie obiektu Canvas dla przykladu rysowania wypelnionych
    private Canvas tworzCanvasWypelnProstokat() {
        Canvas kanwa = new CanvasWypelnProstokat();
        dodajPolecenia(kanwa);
        return kanwa;
    }
        
    // Tworzenie obiektu Canvas dla przykladu rysowania lukow
    private Canvas tworzCanvasLuki() {
        Canvas kanwa = new CanvasLuki();
        dodajPolecenia(kanwa);
        return kanwa;
    }
           
    // Tworzenie obiektu Canvas dla przykladu rysowania wypelnionych lukow
    private Canvas tworzCanvasWypLuki() {
        Canvas kanwa = new CanvasWypelnLuki();
        dodajPolecenia(kanwa);
        return kanwa;
    }    

    // Tworzenie obiektu Canvas dla przykladu rysowania tekstu
    private Canvas tworzCanvasTekst() {
        Canvas kanwa = new CanvasTekst();
        dodajPolecenia(kanwa);
        return kanwa;
    }

}

// Ilustracja rysowania linii
class CanvasLinie extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Wypelnij tlo na czarno
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);

        // Biala pozioma linia
        g.setColor(0xFFFFFF);
        g.drawLine(0, wysokosc/2, szerokosc - 1, wysokosc/2);

        // Zolta kropkowana linia pozioma
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xFFFF00);
        g.drawLine(0, wysokosc/4, szerokosc - 1, wysokosc/4);

        // Ciagla jasnoszara przekatna linia
        g.setGrayScale(255);
        g.setStrokeStyle(Graphics.SOLID);
        g.drawLine(0, 0, szerokosc - 1, wysokosc - 1);
    }    
}

// Ilustracja rysowania prostokatow
class CanvasProstokat extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworz biale tlo
        g.setColor(0xffffff);
        g.fillRect(0, 0, szerokosc, wysokosc);
        
        // Rysuj ciagly prostokat
        g.setColor(0);
        g.drawRect(szerokosc/4, 0, szerokosc/2, wysokosc/4);
                
        // Rysuj przerywany prostokat wewnatrz ciaglego
        g.setStrokeStyle(Graphics.DOTTED);
        g.drawRect(szerokosc/4 + 4, 4, szerokosc/2 - 8, wysokosc/4 - 8);
        
        // Rysuj zaokraglony prostokat
        g.setStrokeStyle(Graphics.SOLID);
        g.drawRoundRect(szerokosc/4, wysokosc/2, szerokosc/2, wysokosc/4, 16, 8);
    }
}

// Ilustracja rysowania wypelnionych prostokatow
class CanvasWypelnProstokat extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworzenie czarnego tla
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);

        // Tworzenie wypelnionego prostokata
        // z kropkowanym prostokatem wokol niego
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0x00ff00);
        g.fillRect(szerokosc/4, wysokosc/4, szerokosc/2, wysokosc/2);
        g.setColor(0xffff00);
        g.drawRect(szerokosc/4, wysokosc/4, szerokosc/2, wysokosc/2);
    }
}

// Ilustracja rysowania lukow
class CanvasLuki extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworzenie czarnego tla
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);

        // Cwiartka kola 90 stopni w kierunku ruchu wskazowek zegara
        // z pozycji na godzinie 3. Pokazanie rowniez otaczajacego prostokata.
        g.setColor(0xffffff);
        g.drawArc(0, 0, szerokosc/2, wysokosc/2, 0, 90);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(0, 0, szerokosc/2, wysokosc/2);

        // Cwiartka kola 90 stopni przeciwnie do kierunku ruchu wskazowek zegara
        // z pozycji na godzinie 3. 
        g.setStrokeStyle(Graphics.SOLID);
        g.setColor(0xffffff);
        g.drawArc(szerokosc/2, 0, szerokosc/2, wysokosc/2, 0, -90);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(szerokosc/2, 0, szerokosc/2, wysokosc/2);
       
        // Eliptyczny luk z pozycji na godzinie szostaj
        // przeciwnie do ruchu wskazowek zegara, 180 stopni
        g.setStrokeStyle(Graphics.SOLID);
        g.setColor(0xffffff);
        g.drawArc(0, wysokosc/2, szerokosc, wysokosc/2, -90, -180);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(0, wysokosc/2, szerokosc, wysokosc/2);
    }
}

// Ilustracja rysowania wypelnionych lukow
class CanvasWypelnLuki extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworzenie czarnego tla
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);

        // Cwiartka kola 90 stopni w kierunku ruchu wskazowek zegara
        // z pozycji na godzinie 3. Pokazanie rowniez otaczajacego prostokata.
        g.setColor(0xffffff);
        g.fillArc(0, 0, szerokosc/2, wysokosc/2, 0, 90);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(0, 0, szerokosc/2, wysokosc/2);

        // Cwiartka kola 90 stopni przeciwnie do kierunku ruchu wskazowek zegara
        // z pozycji na godzinie 3. 
        g.setStrokeStyle(Graphics.SOLID);
        g.setColor(0xffffff);
        g.fillArc(szerokosc/2, 0, szerokosc/2, wysokosc/2, 0, -90);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(szerokosc/2, 0, szerokosc/2, wysokosc/2);
       
        // Eliptyczny luk z pozycji na godzinie szostaj
        // przeciwnie do ruchu wskazowek zegara, 180 stopni
        g.setStrokeStyle(Graphics.SOLID);
        g.setColor(0xffffff);
        g.fillArc(0, wysokosc/2, szerokosc, wysokosc/2, -90, -180);
        g.setStrokeStyle(Graphics.DOTTED);
        g.setColor(0xffff00);
        g.drawRect(0, wysokosc/2, szerokosc, wysokosc/2);
    }
}

// Ilustracja rysowania tekstu
class CanvasTekst extends Canvas {
    public void paint(Graphics g) {
        int szerokosc = getWidth();
        int wysokosc = getHeight();

        // Tworzenie czarnego tla
        g.setColor(0);
        g.fillRect(0, 0, szerokosc, wysokosc);
        
        // Gorny lewy rog ekranu
        g.setColor(0xffffff);
        g.drawString("Gorny lewy", 0, 0, Graphics.TOP | Graphics.LEFT);
        
        // Narysowanie kolejnego ciagu we wierszu ponizej
        Font czcionka = g.getFont();
        g.drawString("Ponizej lewego gornego", 0, czcionka.getHeight(), Graphics.TOP | Graphics.LEFT);
        
        // Dolny prawy rog ekranu
        g.drawString("Prawy dolny", szerokosc, wysokosc, Graphics.BOTTOM | Graphics.RIGHT);
        
        // Laczenie czckonki z kolorem
        String str = "Czcionki ";
        czcionka = Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_UNDERLINED, Font.SIZE_LARGE);
        g.setFont(czcionka);
        g.drawString(str, 0, wysokosc/2, Graphics.LEFT | Graphics.BASELINE);
        
        int x = czcionka.stringWidth(str);
        g.setColor(0x00ff00);
        g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD | Font.STYLE_ITALIC, Font.SIZE_MEDIUM));
        g.drawString("i kolory", x, wysokosc/2, Graphics.LEFT | Graphics.BASELINE);
    }
}