package helion.rozdzial5;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class AnimacjaMIDlet2 extends AnimacjaMIDlet {

    // Tworzenie AnimacjaCanvas2
    protected AnimacjaMIDlet.AnimacjaCanvas tworzAnimacjaCanvas() {
        return new AnimacjaCanvas2();
    }
    
    class AnimacjaCanvas2 extends AnimacjaMIDlet.AnimacjaCanvas {

        // Nadpisanie metody paint z klasy bazowej
        // w celu wykorzytania prostokata wycinka
        protected void paint(Graphics g) {
            // Pobranie prostokata wycinka
            int obciecieX = g.getClipX();
            int obciecieY = g.getClipY();
            int obciecieSzer = g.getClipWidth();
            int obciecieWys = g.getClipHeight();
            
            // Malowanie kolorem tla - tylko
            // obszar w prostokacie wycinku
            g.setColor(tlo);
            g.fillRect(obciecieX, obciecieY, obciecieSzer, obciecieWys);
            
            // Draw all of the bloki
            g.setColor(pioro);
            synchronized (this) {
                for (int i = 0, ilosc = bloki.length; i < ilosc; i++) {
                    g.fillRect(bloki[i].x, bloki[i].y, ROZMIAR, ROZMIAR);
                }
            }
        }       
                
        // Wywolywana po zakonczeniu stopera.
        public synchronized void przesunWszystkieBloki() {
            // Uaktualnienie pozycji i szybkosci wszystkich blokow
            // oraz przemalowanie tylko czesci ekranu, ktora zajmuja
            for (int i = 0, ilosc = bloki.length; i < ilosc; i++) {
                // Zadanie odmalowania obecnej lokalizacji
                Blok blok = bloki[i];
                repaint(blok.x, blok.y, ROZMIAR, ROZMIAR);
                
                bloki[i].move();
                
                // Zadanie przemalowania nowej lokalizacji
                repaint(blok.x, blok.y, ROZMIAR, ROZMIAR);
            }
        }
    }
}
