package helion.rozdzial4;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class TextBoxMIDlet extends MIDlet {

    // Maksymalna wielkosc tekstu w oknie TextBox
    private static final int MAKS_ROZM_TEKST = 64;
    
    // Obiekt TextBox
    protected TextBox textBox;
    
    // Obiekt Display MIDletu
    protected Display ekran;
    
    // Znacznik oznaczajacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    protected void startApp() {
        if (!uruchomiony) {
            // Pierwsze przejscie - inicjalizacja
            // Pobranie tekstu do wyswietlenia
            String ciag = null;
            try {
                InputStream is = getClass().getResourceAsStream("zasoby/tekst.txt");
                InputStreamReader r = new InputStreamReader(is);
                char[] bufor = new char[32];
                StringBuffer sb = new StringBuffer();
                int licz;
                while ((licz = r.read(bufor, 0, bufor.length)) > -1) {
                    sb.append(bufor, 0, licz);
                }
                ciag = sb.toString();
            } catch (IOException ex) {
                ciag = "Nieudane zaadowanie tekstu";
            }
            
            // Tworzenie obiektu TextBox
            textBox = new TextBox("Przyklad TextBox", ciag, 
                                MAKS_ROZM_TEKST, TextField.ANY);
            
            // Tworzenie i instalowanie przewijanego tekstu
            Ticker przewin = new Ticker("To jest tekst przewijany...");
            textBox.setTicker(przewin);
            
            // Umieszczenie elementu TextBox jako biecego ekranu
            ekran = Display.getDisplay(this);            
            ekran.setCurrent(textBox);

            uruchomiony = true;
        }        
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }
}
