package helion.rozdzial4;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

import javax.microedition.lcdui.*;

public class TextBox2MIDlet extends TextBoxMIDlet implements CommandListener {

    // Polecenie Koniec.
    private static final Command POLECENIE_KONIEC = 
                        new Command("Koniec", Command.EXIT, 0);
    
    // Polecenie OK.
    private static final Command POLECENIE_OK =
                        new Command("OK", Command.OK, 0);
    
    // Czyszczenie zawartosci pola tekstowego.
    private static final Command POLECENIE_CZYSC =
                        new Command("Czysc", Command.SCREEN, 1);
    
    // Odwrocenie zawartosci pola tekstowego.
    private static final Command POLECENIE_ODWROC =
                        new Command("Odwroc", Command.SCREEN, 1);

    protected void startApp() {
        boolean pierwszyRaz = !uruchomiony;
        super.startApp();
        
        // Jezeli jest to pierwsze uruchomienie metody startApp(),
        // instalacja polecen.
        if (pierwszyRaz) {
            textBox.addCommand(POLECENIE_OK);            
            textBox.addCommand(POLECENIE_KONIEC);
            textBox.addCommand(POLECENIE_CZYSC);            
            textBox.addCommand(POLECENIE_ODWROC);            
            textBox.setCommandListener(this);
        }
    }
    
    // Implementacja polecen.
    public void commandAction(Command c, Displayable d) {
        if (c == POLECENIE_KONIEC) {
            destroyApp(true);
            notifyDestroyed();
        } else if (c == POLECENIE_OK) {
            System.out.println("Nacisnieto OK");
        } else if (c == POLECENIE_CZYSC) {
            textBox.setString(null);
        } else if (c == POLECENIE_ODWROC) {
            String str = textBox.getString();
            if (str != null) {
                StringBuffer sb = new StringBuffer(str);
                textBox.setString(sb.reverse().toString());
            }
        }
    }    
}
