package helion.rozdzial4;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ElementMIDlet extends MIDlet 
        implements CommandListener, ItemStateListener {

    // Obiekt Display MIDletu
    private Display ekran;
        
    // Znacznik oznaczajacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieExit;
    
    // Polecenie powrot do listy przykladow
    private Command poleceniePowrot;
    
    // Lista przykladow 
    private List listaPrzykl;
    
    // Ekrany wykorzystywane do demonstrowania roznych obiektow Item
    private Screen[] ekrany;
    
    // Nazwy przykladow wykorzystywane do wypelnienia listy.
    private String[] przyklady = {
        "StringItem", "TextField", "DateField",
        "ImageItem", "Gauge", "ChoiceGroup",
        "List", "Alert", "Sound"
    };
    
    // Lista typow ostrzezen
    private AlertType[] typyOstrzezen = new AlertType[] {
        AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR,
        AlertType.INFO, AlertType.WARNING, null
    };
    
    private String[] nazwyTypowOstrzezen = new String[] {
        "ALARM", "POTWIERDZENIE", "BLAD", "INFORMACJA", "OSTRZEZENIE", "Brak"
    };

    protected void startApp() {
        if (!uruchomiony) {
            uruchomiony = true;
            ekran = Display.getDisplay(this);
            
            // Tworzenie wspolnych polecen
            tworzPolecenia();
            
            // Tworzenie ekranow
            tworzEkrany();
            
            // Tworzenie listy przykladow
            tworzListe();
            
            // Rozpoczecie pracy od wyswietlenia listy
            ekran.setCurrent(listaPrzykl);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == listaPrzykl) {
            // Wybrano nowy przyklad
            int indeks = listaPrzykl.getSelectedIndex();
            ekran.setCurrent(ekrany[indeks]);
        } else if (c == polecenieExit) {
            // Koniec. Nie ma potrzeby wywolywania metody destroyApp
            // poniewaz jest pusta.
            notifyDestroyed();
        } else if (c == poleceniePowrot) {
            // Powrot do glownej listy wyboru
            ekran.setCurrent(listaPrzykl);
        } else if (c == List.SELECT_COMMAND) {
            // Wybor dokonany przez liste IMPLICIT
            obslugaWyboru((Choice)d);
        }
    }
    
    public void itemStateChanged(Item element) {        
        if (element instanceof TextField) {
            System.out.println("Zawartosc pola tekstowego: <" +
                            ((TextField)element).getString() + ">");
        } else if (element instanceof DateField) {
            DateField df = (DateField)element;
            Date data = df.getDate();
            if (data != null) {
                Calendar kalendarz = Calendar.getInstance();
                kalendarz.setTime(data);
                System.out.println("Pole daty ustawione na " + data);
            } else {
                System.out.println("Pole daty ustawione na null");
            }
        } else if (element instanceof Gauge) {
            int wartosc = ((Gauge)element).getValue();
            System.out.println("Wartosc wskaznika ustawiona na " + wartosc);
        } else if (element instanceof ChoiceGroup) {
            obslugaWyboru((Choice)element);
        } else {
            System.out.println("Zmiana stanu elementu w " + element);
        }
    }    
    
    private void tworzPolecenia() {
        polecenieExit = new Command("Koniec", Command.EXIT, 0);
        poleceniePowrot = new Command("Wstecz", Command.BACK, 1);
    }
    
    private void tworzListe() {
        listaPrzykl = new List("Wybor przykladu", List.IMPLICIT);
        for (int i = 0; i < przyklady.length; i++) {
            listaPrzykl.append(przyklady[i], null);
        } 
        listaPrzykl.setCommandListener(this);
    }
    
    private void tworzEkrany() {
        ekrany = new Screen[przyklady.length];
        ekrany[0] = tworzFormularzCiagow();
        ekrany[1] = tworzFormularzPolaTekst();
        ekrany[2] = tworzFormularzPolaDaty();
        ekrany[3] = tworzFormularzListyRys();
        ekrany[4] = tworzFormularzWskaznika();
        ekrany[5] = tworzFormularzGrupyWyboru();
        ekrany[6] = tworzPrzykladLista();
        ekrany[7] = tworzFormularzOstrzezenie();
        ekrany[8] = tworzFormularzDzwieki();
    }

    private void dodajPolecenia(Displayable d) {
        d.addCommand(polecenieExit);
        d.addCommand(poleceniePowrot);
        d.setCommandListener(this);
        if (d instanceof Form) {
            ((Form)d).setItemStateListener(this);
        }
    }
    
    // Przyklad dla klasy StringItem
    private Form tworzFormularzCiagow() {
        Form formularz = new Form("StringItem");
        
        formularz.append(new StringItem("Stan ", "OK"));
        formularz.append(new StringItem(null, "Brak etykiety\n"));
        formularz.append(new StringItem(null, "Podzial\nwiersza"));
        formularz.append(new StringItem("Etykieta", "Tekst."));
        formularz.append(new StringItem("Etykieta2 ", "Tekst2."));
        
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla klasy TextField
    private Form tworzFormularzPolaTekst() {
        Form formularz = new Form("TextField");
        
        formularz.append(new TextField("Dowolne", null, 8, TextField.ANY));
        formularz.append(new TextField("Telefon", "1234567890", 10, TextField.PHONENUMBER));
        formularz.append(new TextField("Liczba", "12345", 8, TextField.NUMERIC));
        formularz.append(new TextField("Haslo", null, 8, TextField.PASSWORD | TextField.NUMERIC));
        
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla klasy DateField
    private Form tworzFormularzPolaDaty() {
        Form formularz = new Form("DateField");
        
        // Pobranie obiektu Calendar dla daty i czasu poczatku epoki
        Calendar bazowyKalendarz = Calendar.getInstance();
        Date bazowaData = new Date(0);
        bazowyKalendarz.setTime(bazowaData);
        
        // pobranie obiektu Calendar dla chwili obecnej i uzycie wartosci epoki
        Calendar kalendarz = Calendar.getInstance();
        Date teraz = new Date();       
        kalendarz.setTime(teraz);
        kalendarz.set(Calendar.YEAR, bazowyKalendarz.get(Calendar.YEAR));
        kalendarz.set(Calendar.MONTH, bazowyKalendarz.get(Calendar.MONTH));
        kalendarz.set(Calendar.DATE, bazowyKalendarz.get(Calendar.DATE));
        
        DateField tylkoCzas = new DateField("Czas", DateField.TIME);
        DateField tylkoData = new DateField("Data", DateField.DATE);
        DateField dataCzas = new DateField("Razem", DateField.DATE_TIME);
        
        tylkoCzas.setDate(kalendarz.getTime());
        tylkoData.setDate(teraz);
        dataCzas.setDate(teraz);
        
        formularz.append(tylkoCzas);
        formularz.append(tylkoData);
        formularz.append(dataCzas);
       
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla klasy ImageItem
    private Form tworzFormularzListyRys() {
        Form formularz = new Form("ImageItem");
        
        try {
            Image czerwony = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image niebieski = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");

            // Pozycje ImageItem z etykietami
            // (1)
            formularz.append(new ImageItem("Srodek", czerwony, ImageItem.LAYOUT_CENTER, null));
            
            // (2)
            formularz.append(new ImageItem("Lewo", czerwony, ImageItem.LAYOUT_LEFT, null));
            
            // (3)
            formularz.append(new ImageItem("Prawo", czerwony, ImageItem.LAYOUT_RIGHT, null));
            
            // (4)
            formularz.append(new ImageItem("Domyslnie", czerwony, ImageItem.LAYOUT_DEFAULT, null));
            
            // Obiekty ImageItem bez etykiet
            // (5)
            formularz.append(new ImageItem(null, niebieski, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_CENTER | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (6)
            formularz.append(new ImageItem(null, niebieski, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_DEFAULT | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (7)
            formularz.append(new ImageItem(null, niebieski, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_RIGHT | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (8)
            formularz.append(new ImageItem(null, niebieski, ImageItem.LAYOUT_DEFAULT, null)); 
            formularz.append(new ImageItem(null, niebieski, ImageItem.LAYOUT_DEFAULT, null)); 
        } catch (IOException ex) {
            formularz.append("Nieudane zaladowanie rysunkow");
        }
        
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla klasy Gauge
    private Form tworzFormularzWskaznika() {
        Form formularz = new Form("Gauge");
        
        formularz.append(new Gauge(null, true, 100, 50));
        formularz.append(new Gauge(null, true, 100, 25));
        formularz.append(new Gauge(null, false, 100, 50));
        
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla ChoiceGroup
    private Form tworzFormularzGrupyWyboru() {
        Form formularz = new Form("ChoiceGroup");
        
        try {
            Image czerwony = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image zielony = Image.createImage("/helion/rozdzial4/zasoby/zielony.png");
            Image niebieski = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");

            // Grupa pojedynczego wyboru
            String[] ciagi = new String[] { "Czerwony", "Zielony", "Niebieski" };
            Image[] rysunki = new Image[] { czerwony, zielony, niebieski };
            ChoiceGroup grupaPojWyb = new ChoiceGroup("Wybierz jedna", ChoiceGroup.EXCLUSIVE,
                                                        ciagi, rysunki);
            formularz.append(grupaPojWyb);

            // Grupa wielokrotnego wyboru
            ChoiceGroup grupaWielWyb = new ChoiceGroup("Wybierz kilka", ChoiceGroup.MULTIPLE);
            formularz.append(grupaWielWyb);
            grupaWielWyb.append("Korzystaj z SSL", null);
            grupaWielWyb.append("Polacz po bledzie", null);
            grupaWielWyb.append("Wlacz sledzenie", null);
        } catch (IOException ex) {
            formularz.append("Nieudane zaladowanie rysunkow");
        }
        
        dodajPolecenia(formularz);
        return formularz;
    }
    
    // Przyklad dla klasy List
    private Screen tworzPrzykladLista() {
        List lista = new List("List", List.IMPLICIT);

        try {
            Image czerwony = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image zielony = Image.createImage("/helion/rozdzial4/zasoby/zielony.png");
            Image niebieski = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");
            
            lista.append("Czerwony", czerwony);
            lista.append("Zielony", zielony);
            lista.append("Niebieski", niebieski);
        } catch (IOException ex) {
            Form formularz = new Form("Blad");
            formularz.append("Nieudane zaladowanie rysunkow");
            return formularz;
        }
        
        dodajPolecenia(lista);
        return lista;
    }
    
    // Przyklad dla klasy Alert
    private Screen tworzFormularzOstrzezenie() {
        final Form formularz = new Form("Alert");
        
        // Grupa pozwalajaca wybrac pomiedzy modalnym obiektem
        // Alert, a obiektem Alert z okreslonym czasem oczekiwania.
        final ChoiceGroup ograniczonaGrupa = new ChoiceGroup("Opoznienie", Choice.EXCLUSIVE);
        ograniczonaGrupa.append("Ciagle", null);
        ograniczonaGrupa.append("Ograniczenie do 5s", null);
        formularz.append(ograniczonaGrupa);
        
        // Wskaznik pozwlalajacy na wybor przez uzytkownika czasu oczekiwania dla
        // obiektu Alert. Wyswietlany tylko po wybraniu opcji "Ograniczenie"
        final Gauge wskaznik = new Gauge(null, true, 30, 5);
        
        // Grupa pozwalajaca na wybor typu ostrzezenia
        final ChoiceGroup grupa = tworzenieGrupyTypuOstrzezenia(true); 
        formularz.append(grupa);
        
        // Polecenie uzywane do wyswietlenia ostrzezenia
        final Command polecenieOK = new Command("OK", Command.OK, 0);
        
        // Dodanie obiektu CommandListener dla polecen wstecz i koniec
        // oraz specyficznego dla tego formularza polecenia OK
        formularz.addCommand(polecenieOK);
        formularz.addCommand(polecenieExit);
        formularz.addCommand(poleceniePowrot);
        formularz.setCommandListener(new CommandListener() {
            public void commandAction(Command c, Displayable d) {
                if (c == polecenieOK) {
                    // Tworzenie i wyswietlenie ostrzezenia
                    // Typ ostrzezenia jest pobierany z drugiej grupy wyboru
                    int wybranyTyp = grupa.getSelectedIndex();
                    AlertType typOstrzezenia = typyOstrzezen[wybranyTyp];
                    String nazwa = nazwyTypowOstrzezen[wybranyTyp];
                    
                    // Odczytanie czasu oczekiwania. Jezeli zostanie wybrana pierwsza pozycja
                    // grupy, jest to FOREVER. W przeciwnym przypadku jest to wartosc wskaznika.
                    int opoznienie = Alert.FOREVER;
                    String ciagOpoznienia = "brak";
                    if (ograniczonaGrupa.isSelected(1)) {
                        // Wybrano ograniczenie - pobranie opoznienia.
                        opoznienie = wskaznik.getValue() * 1000;
                        ciagOpoznienia = wskaznik.getValue() + "s";
                    }
                    
                    // Utworzenie ostrzezenia i ustawienie opoznienia
                    Alert ostrzezenie = new Alert("Uwaga!",
                        "Typ ostrzezenia: " + nazwa + "\nOpoznienie = " + ciagOpoznienia,
                        null, typOstrzezenia);
                    ostrzezenie.setTimeout(opoznienie);
                    
                    // Wyswietlenie ostrzezenia.
                    ekran.setCurrent(ostrzezenie);
                } else {
                    // Przekierowanie innych do standardowej metody commandAction
                    ElementMIDlet.this.commandAction(c, d);
                }                
            }
        });
        
        // Ustawienie wasnego obiektu ItemStateListener
        formularz.setItemStateListener(new ItemStateListener() {
            public void itemStateChanged(Item element) {
                if (element == ograniczonaGrupa) {
                    if (ograniczonaGrupa.getSelectedIndex() == 0) {
                        // Usuniecie wskaznika
                        formularz.delete(1);
                    } else {
                        // Dodanie wskaznika
                        formularz.insert(1, wskaznik);
                    }
                } else if (element == wskaznik) {               
                    int wartosc = wskaznik.getValue();
                    ograniczonaGrupa.set(1, "Ograniczenie " + wartosc + "s", null);
                }
            }
        });
        return formularz;
    }
    
        
    // Przyklad odtwarzania dzwiekow
    private Screen tworzFormularzDzwieki() {
        final Form formularz = new Form("Sounds");
        
        // Grupa wyboru pozwalajaca wybrac typ dzwieku
        final ChoiceGroup grupa = tworzenieGrupyTypuOstrzezenia(false); 
        formularz.append(grupa);  

        dodajPolecenia(formularz);
        
        // Utworzenie wasnego obiektu ItemStateListener
        formularz.setItemStateListener(new ItemStateListener() {
            public void itemStateChanged(Item element) {
                // Pobranie typu ostrzezenia z grupy wyboru
                int wybranyTyp = grupa.getSelectedIndex();
                AlertType typOstrzezenia = typyOstrzezen[wybranyTyp];
                boolean wynik = typOstrzezenia.playSound(ekran);
                System.out.println("Dzwiek " + (wynik ? "" : "nie ")
                                    + "zostal odegrany.");
                
            }
        });
        return formularz;
    }
    
    // Obsluga wyboru z obiektu Choice 
    private void obslugaWyboru(Choice wybor) {
        int ilosc = wybor.size();
        boolean[] stan = new boolean[ilosc];
        int iloscWybranych = wybor.getSelectedFlags(stan);
        if (iloscWybranych > 0) {
            System.out.println("Wybrane pozycje:");
            for (int i = 0; i < ilosc; i++) {
                if (stan[i]) {
                    System.out.println("\t" + wybor.getString(i));
                }
            }
        } else {
            System.out.println("Brak wybranych pozycji.");
        }
        int indeksWybranego = wybor.getSelectedIndex();
        System.out.println("Indeks wybranej pozycji " + indeksWybranego);
    }
    
    // Tworzenie grupy wyboru zawierajacej typy ostrzezen
    private ChoiceGroup tworzenieGrupyTypuOstrzezenia(boolean bezDodawania) {
        ChoiceGroup grupa = new ChoiceGroup("Typ ostrzezenia", Choice.EXCLUSIVE);
        int ilosc = bezDodawania ? nazwyTypowOstrzezen.length : nazwyTypowOstrzezen.length - 1;
        for (int i = 0; i < ilosc; i++) {
            grupa.append(nazwyTypowOstrzezen[i], null);
        }
        return grupa;
    }
}
