package helion.rozdzial3;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class PrzykladowyMIDlet extends MIDlet {
    
    // Znacznik wskazujacy pierwsze wywolanie startApp
    private boolean uruchomiony = false;
    
    // Watek tla
    private Thread watek;
    
    // Okres stopera
    private int okresStopera;
    
    // Stoper
    private Timer stoper;
    
    // Zadanie uruchamiane przez stoper
    private TimerTask zadanie;
    
    // Wymagany publiczny konstruktor. Moze byc pominiety
    // jezeli nie jest potrzebny i nie ma utworzonych
    // innych konstruktorow.
    public PrzykladowyMIDlet() {
        System.out.println("Konstruktor uruchomiony");
        
        // Pobranie okresu stopera z metryki
        // lub pliku JAD.
        String okres = getAppProperty("Timer-Interval");
        okresStopera = Integer.parseInt(okres); 
        System.out.println("Okres stopera wynosi " + okres);
    }
        
    protected void startApp() throws MIDletStateChangeException {
        if (!uruchomiony) {
            // Pierwsze wywolanie. Tworzenie i uruchomienie stopera.
            uruchomiony = true;
            System.out.println("Metoda startApp wywolana po raz pierwszy");
            startTimer();
        } else {
            // Wznowienie dzialanie po zatrzymaniu.
            System.out.println("Metoda startApp wywolana po zatrzymaniu");
        }
        
        // W kazdym przypadku uruchomienie watku tla.
        synchronized (this) {
            if (watek == null) {
                watek = new Thread() {
                    public void run() {
                        System.out.println("Watek uruchomiony");
                        while (watek == this) {
                            try {
                                Thread.sleep(1000);
                                System.out.println("Watek nadal aktywny");
                            } catch (InterruptedException ex) {
                            }
                        }
                        System.out.println("Watek zakonczony");
                    }
                };
            }
        }
        watek.start();
    }

    protected void pauseApp() {
        // Metoda wywolywana przez zadanie stopera w celwykonania 
        // czynnosci niezbednych do zatrzymania midletu.
        // Zatrzymuje watek tla
        System.out.println("Wywolano pauseApp.");
        synchronized (this) {
            if (watek != null) {
                watek = null;
            }
        }
    }

    protected void destroyApp(boolean unconditional) 
                            throws MIDletStateChangeException {
        // Metoda wywolywana w celu zniszczenia midletu.
        System.out.println("Wywolano destroyApp - parametr 'unconditional' = " 
                            + unconditional);
        if (watek != null) {
            Thread watekTla = watek;
            watek = null;      // Zadanie zniszczenia watku
            try {
                watekTla.join();
            } catch (InterruptedException ex) {
            }
        }
        stopTimer();
    }
    
    // Uruchamia stoper w celu wykonania prostego zadania
    private void startTimer() {
        
        // Tworzy zadanie do wykonania
        zadanie = new TimerTask() {
            private boolean zatrzymany;
            private int licznik;
        
            public void run() {
                // Zatrzymuje lub uruchamia midlet.
                System.out.println("Stoper wstawiony do kolejki");
                if (licznik++ == 4) {
                    // Usuniecie midletu
                    try {
                        PrzykladowyMIDlet.this.destroyApp(true);
                    } catch (MIDletStateChangeException ex) {
                        // Ignorowanie sygnalu!
                    }
                    PrzykladowyMIDlet.this.notifyDestroyed();
                    return;
                }
                if (zatrzymany) {
                    System.out.println(">> Wznawianie midletu");
                    PrzykladowyMIDlet.this.resumeRequest();
                    zatrzymany = false;
                } else {
                    System.out.println(">> Zatrzymywanie midletu");
                    zatrzymany = true;
                    PrzykladowyMIDlet.this.pauseApp();
                    PrzykladowyMIDlet.this.notifyPaused();
                }
            }
        };
        
        // Tworzenie stopera i wstawianie do kolejki wykonania
        stoper = new Timer();
        stoper.schedule(zadanie, okresStopera, okresStopera); 
        System.out.println("Stoper uruchomiony.");
    }
    
    // Zatrzymywanie stopera
    private void stopTimer() {
        if (stoper != null) {
            System.out.println("Zatrzymywanie stopera");
            stoper.cancel();
        }
    }
}
