package helion.rozdzial6;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class SocketMIDlet extends MIDlet
                    implements CommandListener, Runnable {

    private Display display;
    private Form addressForm;
    private Form connectForm;
    private Form displayForm;
    private TextField serverName;
    private TextField serverPort;
    private StringItem messageLabel;
    private StringItem errorLabel;
    private Command okCommand;
    private Command exitCommand;
    private Command backCommand;

    protected void startApp() throws MIDletStateChangeException {
        if (display == null) {
            initialize();
            display.setCurrent(addressForm);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional)
                        throws MIDletStateChangeException {
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == okCommand) {
            Thread t = new Thread(this);
            t.start();
            display.setCurrent(connectForm);
        } else if (cmd == backCommand) {
            display.setCurrent(addressForm);
        } else if (cmd == exitCommand) {
            try {
                destroyApp(true);
            } catch (MIDletStateChangeException ex) {
            }
            notifyDestroyed();
        }
    }

    public void run() {
        InputStream is = null;
        OutputStream os = null;
        StreamConnection socket = null;

        try {
            String server = serverName.getString();
            String port = serverPort.getString();
            String name = "socket://" + server + ":" + port;
            socket = (StreamConnection)Connector.open(name, Connector.READ_WRITE);
        } catch (Exception ex) {
            Alert alert = new Alert("Nieprawidlowy adres",
                        "Podany adres jest nieprawidlowy\n" +
                        "Popraw go i sprobuj ponownie.", null,
                        AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
            display.setCurrent(alert, addressForm);
            return;
        }

        try {
            // Wysylanie komunikatu do serwera
            String request = "GET / HTTP/1.0\n\n";

            os = socket.openOutputStream();
            os.write(request.getBytes());
            os.close();

            // Odczytaj odpowiedz serwera, przy czym nie wiecej niz 128 bajtow.
            is = socket.openInputStream();
            final int MAX_LENGTH = 128;
            byte[] buf = new byte[MAX_LENGTH];
            int total = 0;
            while (total < MAX_LENGTH) {
                int count = is.read(buf, total, MAX_LENGTH - total);
                if (count < 0) {
                    break;
                }
                total += count;
            }
            is.close();
            String reply = new String(buf, 0, total);
            messageLabel.setText(reply);
            socket.close();
            display.setCurrent(displayForm);
        } catch (IOException ex) {
            Alert alert = new Alert("Blad I/O",
                        "W trakcie laczenia sie z serwerem wystapil blad.",
                        null, AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
            display.setCurrent(alert, addressForm);
            return;
        } finally {
            // Zamknij otwarte strumienie i gniazdo
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            } catch (IOException ex1) {
            }
            try {
                if (os != null) {
                    os.close();
                    os = null;
                }
            } catch (IOException ex1) {
            }
            try {
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            } catch (IOException ex1) {
            }
        }
    }

    private void initialize() {
        display = Display.getDisplay(this);

        // Polecenia
        exitCommand = new Command("Exit", Command.EXIT, 0);
        okCommand = new Command("OK", Command.OK, 0);
        backCommand = new Command("Wstecz", Command.BACK, 0);

        // Formularz adresowy
        addressForm = new Form("Klient gniazda");
        serverName = new TextField("Nazwa serwera:", "", 256, TextField.ANY);
        serverPort = new TextField("Port serwera:", "", 8, TextField.NUMERIC);
        addressForm.append(serverName);
        addressForm.append(serverPort);
        addressForm.addCommand(okCommand);
        addressForm.addCommand(exitCommand);
        addressForm.setCommandListener(this);

        // Formularz nawiazywania polaczenia
        connectForm = new Form("Polaczenie");
        messageLabel = new StringItem(null, "Nawiazywanie polaczenia...\nProsze czekac.");
        connectForm.append(messageLabel);
        connectForm.addCommand(backCommand);
        connectForm.setCommandListener(this);

        // Formularz wyswietlania danych
        displayForm = new Form("Odpowiedz serwera");
        messageLabel = new StringItem(null, null);
        displayForm.append(messageLabel);
        displayForm.addCommand(backCommand);
        displayForm.setCommandListener(this);
    }
}