package helion.rozdzial6;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;


public class PersistentRankingMIDlet extends MIDlet
                implements CommandListener, RecordListener, Runnable {

    private Command exitCommand;
    private Command okCommand;
    private Command cancelCommand;
    private Command newCommand;
    private Command checkCommand;
    private Command detailsCommand;
    private Command backCommand;
    private Command deleteCommand;
    private Display display;
    private TextField isbnField;
    private StringItem isbnDisplay;
    private StringItem titleDisplay;
    private StringItem rankingDisplay;
    private StringItem reviewDisplay;
    private StringItem checkTitle;
    private Form isbnForm;
    private Form searchForm;
    private Form resultForm;
    private Form checkForm;
    private List bookList;
    private Vector bookInfoList;
    private Thread searchThread;
    private BookStore bookStore;
    private BookInfo searchBookInfo;

    protected void startApp() throws MIDletStateChangeException {
        if (display == null) {
            initialize();

            // Jezeli w magazynie rekordow znajduja sie
            // informacje o jakichs ksiazkach, pokaz ich liste.
            // W przeciwnym wypadku wyswietl formularz ISBN.
            display.setCurrent(getSelectionScreen());
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional)
                        throws MIDletStateChangeException {
        // Zamknij magazyn rekordow
        if (bookStore != null) {
            try {
                bookStore.removeRecordListener(this);
                bookStore.close();
            } catch (RecordStoreException ex) {
            }
        }
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == exitCommand) {
            try {
                destroyApp(true);
            } catch (MIDletStateChangeException ex) {
            }
            notifyDestroyed();
        } else if (cmd == okCommand) {
            String isbn = isbnField.getString().trim();
            if (!isbn.equals("")) {
                isbnDisplay.setText(isbn);
                display.setCurrent(searchForm);
                searchForBook(new BookInfo(isbn));
            }
        } else if (cmd == cancelCommand) {
            searchThread = null;
            isbnField.setString(null);
            display.setCurrent(getSelectionScreen());
        } else if (cmd == newCommand) {
            isbnField.setString(null);
            display.setCurrent(isbnForm);
        } else if (cmd == detailsCommand || cmd == List.SELECT_COMMAND) {
            int index = bookList.getSelectedIndex();
            searchBookInfo = (BookInfo)bookInfoList.elementAt(index);
            isbnDisplay.setText(searchBookInfo.getIsbn());
            showBookInfo(searchBookInfo);
        } else if (cmd == deleteCommand) {
            int index = bookList.getSelectedIndex();
            BookInfo bookInfo = (BookInfo)bookInfoList.elementAt(index);
            try {
                bookStore.deleteBook(bookInfo);
            } catch (RecordStoreException ex) {
                System.out.println("Kasowanie nie powiodlo sie: " + ex);
            }
        } else if (cmd == checkCommand) {
            String isbn = searchBookInfo.getIsbn();
            checkTitle.setText(searchBookInfo.getTitle());
            display.setCurrent(checkForm);
            searchForBook(searchBookInfo);
        } else if (cmd == backCommand) {
            display.setCurrent(getSelectionScreen());
        }
    }

    public void searchForBook(BookInfo info) {
        searchBookInfo = info;
        searchThread = new Thread(this);
        searchThread.start();
    }

    public void recordAdded(RecordStore recordStore, int recordId) {
        // Uaktualnij liste ksiazek
        populateBookList();
    }

    public void recordChanged(RecordStore recordStore, int recordId) {
        // Uaktualnij liste ksiazek
        populateBookList();
    }

    public void recordDeleted(RecordStore recordStore, int recordId) {
        // Uaktualnij liste ksiazek
        populateBookList();
    }

    public void run() {
        try {
            boolean found = Fetcher.fetch(searchBookInfo);
            if (searchThread == Thread.currentThread()) {
                if (found && searchBookInfo.getTitle() != null) {
                    // Wyswietl informacje o ksiazce
                    showBookInfo(searchBookInfo);

                    // Dodaj do magazynu rekordow informacje o nowej ksiazce
                    bookStore.saveBookInfo(searchBookInfo);
                } else {
                    Alert alert = new Alert("Nie znaleziono", null,
                                        null, AlertType.ERROR);
                    alert.setTimeout(Alert.FOREVER);
                    alert.setString("Nie znaleziono ksiazki o numerze ISBN " +
                                        searchBookInfo.getIsbn());
                    isbnField.setString(null);
                    display.setCurrent(alert, getSelectionScreen());
                }
            }
        } catch (Throwable ex) {
            if (searchThread == Thread.currentThread()) {
                Alert alert = new Alert("Poszukiwanie nieudane", null,
                                        null, AlertType.ERROR);
                alert.setTimeout(Alert.FOREVER);
                alert.setString("Poszukiwanie nieudane:\n" + ex.getMessage());
                isbnField.setString(null);
                display.setCurrent(alert, getSelectionScreen());
            }
        }
    }

    // Wyswietl informacje o ksiazce na formularzu wynikow
    private void showBookInfo(BookInfo info) {
        titleDisplay.setText(info.getTitle());

        int ranking = info.getRanking();
        int lastRanking = info.getLastRanking();
        int change = ranking - lastRanking;
        String rankingText =
                ranking == 0 ? "" :
                    String.valueOf(ranking);
        if (change > 0) {
            rankingText += ", w dol o " + change;
        } else if (change < 0) {
            rankingText += ", DO GORY o " + (-change);
        }
        rankingDisplay.setText(rankingText);

        int reviews = info.getReviews();
        int lastReviews = info.getLastReviews();
        change = reviews - lastReviews;
        String reviewText =
            reviews == 0 ? "" :
                    String.valueOf(reviews);
        if (change > 0) {
            reviewText += ", do gory o " + change;
        }
        reviewDisplay.setText(reviewText);

        display.setCurrent(resultForm);
    }

    // Jezeli w magazynie rekordow znajduja sie
    // informacje o jakichs ksiazkach, pokaz ich liste.
    // W przeciwnym wypadku wyswietl formularz ISBN.
    private Screen getSelectionScreen() {
        return
            bookInfoList.isEmpty() ? (Screen)isbnForm : (Screen)bookList;
    }

    // Zapelnia liste ksiazek
    private void populateBookList() {
        // Usuwa istniejaca zawartosc
        int count = bookList.size();
        for (int i = 0; i < count; i++) {
            bookList.delete(0);
        }
        bookInfoList.removeAllElements();

        // Dodaj wpis dla kazdej ksiazki
        try {
            RecordEnumeration enum = bookStore.getBooks();
            while (enum.hasNextElement()) {
                int id = enum.nextRecordId();
                BookInfo info = bookStore.getBookInfo(id);
                bookInfoList.addElement(info);
                String title = info.getTitle();
                if (title == null || title.equals("")) {
                    title = info.getIsbn();
                }
                bookList.append(title, null);
            }
            enum.destroy();
        } catch (Exception ex) {
            // Po prostu zostaw pusta liste.
        }

        // Formularz z numerami ISBN powinien miec polecenie exit
        // tylko wowczas, gdy ekran z lista ksiazek jest pusty.
        isbnForm.removeCommand(exitCommand);
        if (bookInfoList.isEmpty()) {
            isbnForm.addCommand(exitCommand);
        }
    }

    private void initialize() {
        display = Display.getDisplay(this);

        // Zainicjuj obiekt BookStore
        bookStore = new BookStore();

        exitCommand = new Command("Exit", Command.EXIT, 0);
        okCommand = new Command("OK", Command.OK, 0);
        cancelCommand = new Command("Anuluj", Command.CANCEL, 0);
        newCommand = new Command("Nowa", Command.SCREEN, 1);
        detailsCommand = new Command("Szczegoly", Command.OK, 0);
        checkCommand = new Command("Sprawdz", Command.OK, 0);
        backCommand = new Command("Wstecz", Command.CANCEL, 1);
        deleteCommand = new Command("Usun", Command.SCREEN, 1);

        bookList = new List("Ksiazki", List.IMPLICIT);
        bookList.addCommand(detailsCommand);
        bookList.addCommand(newCommand);
        bookList.addCommand(deleteCommand);
        bookList.addCommand(exitCommand);
        bookInfoList = new Vector();

        isbnForm = new Form("Szukanie ksiazek");
        isbnForm.append("Wprowadz numer ISBN i nacisnij OK:");
        isbnField = new TextField("", null, 10, TextField.ANY);
        isbnForm.append(isbnField);
        isbnForm.addCommand(okCommand);
        isbnForm.addCommand(exitCommand);
        isbnForm.addCommand(backCommand);

        searchForm = new Form("Szukanie ksiazki");
        searchForm.append("Szukam ksiazki o podanym numerze\n");
        isbnDisplay = new StringItem(null, null);
        searchForm.append(isbnDisplay);
        searchForm.append("\nProsze czekac....");
        searchForm.addCommand(cancelCommand);

        checkForm = new Form("Uaktualnienie informacji");
        checkForm.append("Pobieram informacje na temat\n");
        checkTitle = new StringItem(null, null);
        checkForm.append(checkTitle);
        checkForm.append(" z amazon.com\nProsze czekac....");
        checkForm.addCommand(cancelCommand);

        resultForm = new Form("Wynik poszukiwan");
        titleDisplay = new StringItem("Tytul ksiazki: ", null);
        rankingDisplay = new StringItem("Pozycja w rankingu:    ", null);
        reviewDisplay = new StringItem("Liczba recenzji:    ", null);
        resultForm.append(titleDisplay);
        resultForm.append(rankingDisplay);
        resultForm.append(reviewDisplay);
        resultForm.addCommand(backCommand);
        resultForm.addCommand(checkCommand);

        // Obslugujemy zdarzenia zachodzace na wszystkich formularzach
        isbnForm.setCommandListener(this);
        searchForm.setCommandListener(this);
        resultForm.setCommandListener(this);
        bookList.setCommandListener(this);

        // Sprawdzamy, czy lista ksiazek nie ulegla zmianie
        bookStore.addRecordListener(this);

        // Wczytujemy ksiazki przechowywane w magazynie rekordow
        populateBookList();
    }
}