package helion.rozdzial6;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;

// Klasa szukajaca w strumieniu wejsciowym
// konkretnych lancuchow znakow bez wczytywania
// calego strumienia do jednego duzego lancucha.
public class InputHelper {

    // Rozmiar bufora wejsciowego
    private static final int BUFFER_SIZE = 1024;

    // Bufor wejsciowy
    private final char[] buffer = new char[BUFFER_SIZE];

    // Liczba znakow pozostalych w buforze
    private int charsLeft;

    // Indeks nastepnego znaku w buforze
    private int nextChar;

    // InputStreamReader wykorzystywany do mapowania znakow na format Unicode
    private InputStreamReader reader;

    // Tworzy obiekt pomocniczy umozliwiajacy wczytanie danego strumienia
    public InputHelper(InputStream is) {
        reader = new InputStreamReader(is);
    }

    // Sprzatamy po obiekcie gdy nie jest on juz potrzebny
    public void dispose() {
        if (reader != null) {
            try {
                reader.close();
            } catch (IOException ex) {
            }
            reader = null;
        }
    }

    // Szuka w strumieniu wejsciowym okreslonego ciagu
    // znakow i ustawia znacznik strumienia tak, aby
    // wskazywal na znak lezacy zaraz za ostatnim znakiem
    // szukanego lancucha. Zwraca wartosc true jezeli ciag zostanie
    // znaleziony i false w przeciwnym wypadku (przy zalozeniu,
    // ze przeszukano juz caly strumien)
    public boolean moveAfterString(String str) throws IOException {
        char[] chars = str.toCharArray();
        int count = chars.length;
        char firstChar = chars[0];

        char c = (char)0;
        for (;;) {
            if (c != firstChar && !findNext(firstChar)) {
                // Osiagnieto koniec strumienia wejsciowego
                return false;
            }

            boolean mismatch = false;
            for (int i = 1; i < count; i++) {
                c = getNext();
                if (c != chars[i]) {
                    mismatch = true;
                    break;
                }
            }

            if (!mismatch) {
                return true;
            }

            // Niezgodnosc. Zmienna 'c' zawiera pierwszy nie zgadzajacy
            // sie znak - przechodzimy przez petle jeszcze raz, poczawszy
            // od tego znaku. Musimy to zrobic, bo inaczej szukajac slowa
            // "web" dostalibysmy "wweb"
        }
    }

    // Pobiera znaki skladajace sie na liczbe, ignorujac separator
    // tysiecy. Liczba zaczyna sie od biezacej pozycji na wejsciu.
    // Wszelkie poprzedzajace ja wartosci nienumeryczne sa pomijane.
    public String gatherNumber() throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean gotNumeric = false;
        for (;;) {
            char c = getNext();

            // Pomijamy az nie trafimy na cyfre.
            boolean isDigit = Character.isDigit(c);
            if (!gotNumeric && !isDigit) {
                continue;
            }
            gotNumeric = true;
            if (!isDigit) {
                if (c == '.' || c == ',') {
                    continue;
                }
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    // Pobiera pozostala czesc biezacego wiersza
    // i zwraca ja w postaci obiektu StringBuffer
    public StringBuffer getRestOfLine() throws IOException {

        StringBuffer sb = new StringBuffer();
        char c;
        for (;;) {
            c = getNext();
            if (c == '\n' || c == (char)0) {
                break;
            }
            sb.append(c);
        }
        return sb;
    }

    // Pobiera kolejny znak ze strumienia i zwraca (char)0
    // po przeczytaniu wszystkich znakow na wejsciu.
    private char getNext() throws IOException {
        if (charsLeft == 0) {
            charsLeft = reader.read(buffer, 0, BUFFER_SIZE);
            if (charsLeft < 0) {
                return (char)0;
            }
            nextChar = 0;
        }
        charsLeft--;
        return buffer[nextChar++];
    }

    // Znajduje w strumieniu wejsciowym nastepne miejsce,
    // w ktorym wystepuje podany znak. Znacznik strumienia
    // umieszczany jest zaraz za tym znakiem. Jezeli osiagniemy EOF,
    // a znak nie zostanie znaleziony, metoda zwroci wartosc false.
    private boolean findNext(char c) throws IOException {
        for (;;) {
            if (charsLeft == 0) {
                charsLeft = reader.read(buffer, 0, BUFFER_SIZE);
                if (charsLeft < 0) {
                    return false;
                }
                nextChar = 0;
            }
            charsLeft--;
            if (c == buffer[nextChar++]) {
                return true;
            }
        }
    }
}