package helion.rozdzial6;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class HttpMIDlet extends MIDlet
                    implements CommandListener, Runnable {

    private Display display;
    private Form addressForm;
    private Form connectForm;
    private Form displayForm;
    private TextField serverURL;
    private StringItem messageLabel;
    private StringItem errorLabel;
    private Command okCommand;
    private Command exitCommand;
    private Command backCommand;

    protected void startApp() throws MIDletStateChangeException {
        if (display == null) {
            initialize();
            display.setCurrent(addressForm);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional)
                        throws MIDletStateChangeException {
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == okCommand) {
            Thread t = new Thread(this);
            t.start();
            display.setCurrent(connectForm);
        } else if (cmd == backCommand) {
            display.setCurrent(addressForm);
        } else if (cmd == exitCommand) {
            try {
                destroyApp(true);
            } catch (MIDletStateChangeException ex) {
            }
            notifyDestroyed();
        }
    }

    public void run() {
        InputStream is = null;
        HttpConnection conn = null;

        try {
            String url = serverURL.getString();
            if (!url.startsWith("http://") &&
			!url.startsWith("https://")) {
                url = "http://" + url;
            }
            conn = (HttpConnection)Connector.open(url, Connector.READ_WRITE);
        } catch (Exception ex) {
		System.out.println(ex);
		ex.printStackTrace();
            Alert alert = new Alert("Nieprawidlowy adres",
                        "Podany adres jest nieprawidlowy\n" +
                        "Popraw go i sprobuj ponownie.", null,
                        AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
            display.setCurrent(alert, addressForm);
            return;
        }

        try {
            // Pobierz zadana strone odczytujac z niej
            // co najwyzej 128 bajtow
            if (conn.getResponseCode() == HttpConnection.HTTP_OK) {
                is = conn.openInputStream();
                final int MAX_LENGTH = 128;
                byte[] buf = new byte[MAX_LENGTH];
                int total = 0;
                while (total < MAX_LENGTH) {
                    int count = is.read(buf, total, MAX_LENGTH - total);
                    if (count < 0) {
                        break;
                    }
                    total += count;
                }
                is.close();
                String reply = new String(buf, 0, total);
                messageLabel.setText(reply);
            } else {
                messageLabel.setText("Failed: error " + conn.getResponseCode() +
                                "\n" + conn.getResponseMessage());
            }

            // Pobierz kod odpowiedzi i wydrukuj wszystkie naglowki
            System.out.println("Kod odpowiedzi = " + conn.getResponseCode());
            System.out.println("Tresc odpowiedzi = " + conn.getResponseMessage());
            for (int i = 0; ; i++) {
                String key = conn.getHeaderFieldKey(i);
                String value = conn.getHeaderField(i);
                if (key == null) {
                    // Osiagnieto ostatni naglowek
                    break;
                }
                System.out.println(key + " = " + value);
            }
            conn.close();
            display.setCurrent(displayForm);
        } catch (IOException ex) {
		System.out.println(ex);
		ex.printStackTrace();
            Alert alert = new Alert("Blad I/O",
                        "W trakcie laczenia sie z serwerem wystapil blad.",
                        null, AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
            display.setCurrent(alert, addressForm);
            return;
        } finally {
            // Zamknij otworzone strumienie
           try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            } catch (IOException ex1) {
            }
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (IOException ex1) {
            }
        }
    }

    private void initialize() {
        display = Display.getDisplay(this);

        // Polecenia
        exitCommand = new Command("Exit", Command.EXIT, 0);
        okCommand = new Command("OK", Command.OK, 0);
        backCommand = new Command("Wstecz", Command.BACK, 0);

        // Formularz adresu
        addressForm = new Form("Klient HTTP");
        serverURL = new TextField("URL:", "", 256, TextField.ANY);
        addressForm.append(serverURL);
        addressForm.addCommand(okCommand);
        addressForm.addCommand(exitCommand);
        addressForm.setCommandListener(this);

        // Formularz polaczenia
        connectForm = new Form("Laczenie");
        messageLabel = new StringItem(null, "Laczenie...\nProsze czekac.");
        connectForm.append(messageLabel);
        connectForm.addCommand(backCommand);
        connectForm.setCommandListener(this);

        // Formularz wyswietlania
        displayForm = new Form("Odpowiedz serwera");
        messageLabel = new StringItem(null, null);
        displayForm.append(messageLabel);
        displayForm.addCommand(backCommand);
        displayForm.setCommandListener(this);
    }
}