package helion.rozdzial5;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class AtrybutyMIDlet extends MIDlet 
                        implements CommandListener {

    // Obiekt klasy Display biezacego MIDletu
    private Display ekran;
        
    // Znacznik wskazujacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieKoniec;
    
    protected void startApp() {
        if (!uruchomiony) {
            ekran = Display.getDisplay(this);
            Canvas kanwa = new PustaKanwa();
            
            // Utworzenie formularza, wyswietlajacego atrybuty klas Display i Canvas
            Form formularz = new Form("Atrybuty");
            polecenieKoniec = new Command("Koniec", Command.EXIT, 0);
            formularz.addCommand(polecenieKoniec);
            
            boolean isColor = ekran.isColor();
            formularz.append(new StringItem(isColor ? "Kolory: " : "Szarosci: ",
                                String.valueOf(ekran.numColors())));
            formularz.append(new StringItem("Szerokosc: ", String.valueOf(kanwa.getWidth())));
            formularz.append(new StringItem("Wysokosc: ", String.valueOf(kanwa.getHeight())));
            formularz.append(new StringItem("Wskaznik? ", 
                                String.valueOf(kanwa.hasPointerEvents())));
            formularz.append(new StringItem("Ruch? ",
                                String.valueOf(kanwa.hasPointerMotionEvents())));
            formularz.append(new StringItem("Powtarzanie? ", 
                                String.valueOf(kanwa.hasRepeatEvents())));
            formularz.append(new StringItem("Buforowanie? ", 
                                String.valueOf(kanwa.isDoubleBuffered())));
            
            formularz.setCommandListener(this);

            ekran.setCurrent(formularz);
            
            uruchomiony = true;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == polecenieKoniec) {
            //Wyjscie. Nie ma potrzeby wywolywania callApp, poniewaz jest pusta
            notifyDestroyed();
        }
    } 
    
    // Obiekt Canvas, w ktorym nie ma nic narysowanego
    static class PustaKanwa extends Canvas {
        protected void paint(Graphics g) {
            // Nic nie rob
        }
    }
}