package helion.rozdzial5;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.midlet.MIDlet;

public class AnimacjaMIDlet extends MIDlet 
                        implements CommandListener, ItemStateListener {

    // Obiekt klasy Display biezacego MIDletu
    private Display ekran;
        
    // Znacznik wskazujacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieKoniec;
    
    // Polecenie Ustawienia
    private Command polecenieUstaw;
    
    // Polecenie Uruchom
    private Command polecenieUruchom;
    
    // Formularz konfiguracji
    private Form formularz;
    
    // Obszar animacji
    private AnimacjaCanvas kanwa;
    
    // Wskaxnik dla ilosci blokow
    private Gauge wskaznikBloki;
    
    // Wskaznik dla ilosci klatek na sekunde
    private Gauge wskaznikKlatki;
    
    // Poczatkowa szybkosc klatek
    private static final int KLATKI_SEK = 1;
    
    // Poczatkowa ilosc blokow blokow
    private static final int ILOSC_BLOKOW = 1;
    
    protected void startApp() {
        if (!uruchomiony) {
            ekran = Display.getDisplay(this);
            formularz = new Form("Animacja");
            wskaznikKlatki = new Gauge("Klatki/sek", true, 10, KLATKI_SEK);
            wskaznikBloki = new Gauge("Bloki", true, 4, ILOSC_BLOKOW);
            formularz.append(wskaznikKlatki);
            formularz.append(wskaznikBloki);
            formularz.setItemStateListener(this);
            
            kanwa = tworzAnimacjaCanvas();
            
            polecenieKoniec = new Command("Koniec", Command.EXIT, 0);
            polecenieUstaw = new Command("Ustaw", Command.SCREEN, 0);
            polecenieUruchom = new Command("Start", Command.SCREEN, 0);
            
            kanwa.addCommand(polecenieKoniec);
            kanwa.addCommand(polecenieUstaw);
            formularz.addCommand(polecenieKoniec);
            formularz.addCommand(polecenieUruchom);
            
            formularz.setCommandListener(this);
            kanwa.setCommandListener(this);
            
            ekran.setCurrent(formularz);
            uruchomiony = true;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }    

    public void commandAction(Command c, Displayable d) {
        if (c == polecenieKoniec) {
            // Koniec. nie ma potrzeby wywolywania destroyApp
            // poniewaz jest pusty.
            notifyDestroyed();
        } else if (c == polecenieUruchom) {
            ekran.setCurrent(kanwa);
        } else if (c == polecenieUstaw) {
            ekran.setCurrent(formularz);
        }
    }
    
    public void itemStateChanged(Item element) {
        if (element == wskaznikBloki) {
            int ilosc = wskaznikBloki.getValue();
            if (ilosc < 1) {
                ilosc = 1;
            }
            kanwa.ustawIloscBlokow(ilosc);
        } else if (element == wskaznikKlatki) {
            int ilosc = wskaznikKlatki.getValue();
            if (ilosc < 1) {
                ilosc = 1;
            }
            kanwa.ustawIloscKlatek(ilosc);
        }            
    } 
    
    // Tworzenie obiektu rysujacego bloki
    protected AnimacjaCanvas tworzAnimacjaCanvas() {
        return new AnimacjaCanvas();
    }
    
    class AnimacjaCanvas extends Canvas {

        // Rozmiar blokow
        protected static final int ROZMIAR = 4;
        
        // Poczatkowe predkosci w kierunku X
        protected final int[] predkosciX = { 2, -2, 0, -2 };
        
        // Poczatkowe predkosci w kierunku Y
        protected final int[] predkosciY = { 2, -2, 2, -0 };
        
        // Kolor tla
        protected int tlo = ekran.isColor() ? 0 : 0xc0c0c0;
            
        // Kolor glowny
        protected int pioro = ekran.isColor() ? 0xffff00 : 0;
        
        // Szerokosc ekranu
        protected int szerokosc = getWidth();
        
        // Wysokosc ekranu
        protected int wysokosc = getHeight();
        
        // Czestotliwosc aktualizacji ekranu
        protected int iloscKlatek;
        
        // Bloki rysowane na ekranie
        protected Blok[] bloki;
        
        // Stoper aktualizujcy
        protected Timer stoper;
        
        // Zadanie aktualizujace
        protected TimerTask zadanieAkt;
        
        // Pobranie maksymalnej ilosci blokow
        public int pobierzMaksBloki() {
            return bloki.length;
        }
        
        // Tworzenie obiektu Canvas z domylnymi ustawieniami
        AnimacjaCanvas() {
            ustawIloscBlokow(ILOSC_BLOKOW);
            ustawIloscKlatek(KLATKI_SEK);
        }
        
        // Ustawia maksymalna ilosc blokow do narysowania
        public void ustawIloscBlokow(int ilosc) {
            if (ilosc > predkosciX.length) {
                throw new IllegalArgumentException("Nie mozna miec wiecej niz " 
                                + predkosciX.length + " blokow");
            }
            
            bloki = new Blok[ilosc];
            tworzBloki();
        }
        
        // Pobranie ilosci blokow do narysowania
        public int pobierzIloscBlokow() {
            return bloki.length;
        }
        
        // Ustawia ilosc aktualizacji na sekunde
        public void ustawIloscKlatek(int iloscKlatek) {
            if (iloscKlatek < 1 || iloscKlatek > 10) {
                throw new IllegalArgumentException("Ilosc klatek musi byc > 0 i <= 10");
            }
            this.iloscKlatek = iloscKlatek;
            if (isShown()) {
                uruchomStoper();
            }
        }
        
        // Pobranie ilosci aktualizacji na sekunde
        public int pobiezIloscKlatek() {
            return iloscKlatek;
        }  
          
        // Rysuje tlo oraz wszystkie bloki 
        // na wlasciwych pozycjach.
        protected void paint(Graphics g) {
            // Maluje kolorem tla
            g.setColor(tlo);
            g.fillRect(0, 0, szerokosc, wysokosc);
            
            // Rysuje wszystkie bloki
            g.setColor(pioro);
            synchronized (this) {
                for (int i = 0, ilosc = bloki.length; i < ilosc; i++) {
                    g.fillRect(bloki[i].x, bloki[i].y, ROZMIAR, ROZMIAR);
                }
            }
        }
        
        // Powiadomienie o wyswietleniu obiektu Canvas
        protected void showNotify() {
            // Uruchomienie stopera ramek
            uruchomStoper();
        }
        
        // Powiadomienie o ukryciu obiektu Canvas
        protected void hideNotify() {
            // Zatrzymanie stopera ramek 
            stopFrameTimer();
        }
        
        // Tworzy bloki do wyswietlenia
        private void tworzBloki() {
            int startX = (szerokosc - ROZMIAR)/2;
            int startY = (wysokosc - ROZMIAR)/2;
            for (int i = 0, ilosc = bloki.length; i < ilosc; i++) {
                bloki[i] = new Blok(startX, startY, predkosciX[i], predkosciY[i]);
            }
        }
        
        // Uruchomienie stopera przerysowania ramek
        protected void uruchomStoper() {
            stoper = new Timer();
            
            zadanieAkt = new TimerTask() {
                public void run() {
                    przesunWszystkieBloki();
                }
            };
            long odstep = 1000/iloscKlatek;
            stoper.schedule(zadanieAkt, odstep, odstep);
        }
        
        // Zatrzymanie stopera przerysowania ramek
        protected void stopFrameTimer() {
            stoper.cancel();
        }
        
        // Wywolywana po zakonczeniu pracy stopera.
        public synchronized void przesunWszystkieBloki() {
            // Uaktualnienie pozycji oraz predkosci blokow
            for (int i = 0, ilosc = bloki.length; i < ilosc; i++) {
                bloki[i].move();
                
                // Zadanie przemalowania ekranu
                repaint();
            }
        }
        
        // Klasa wewnetrzna reprezentujaca blok na ekranie
        class Blok {
            int x;      // wspolrzedna x
            int y;      // wspolrzedna y
            int predkX; // predkosc w kierunku X
            int predkY; // predkosc w kierunku Y
            
            Blok(int x, int y, int predkX, int predkY) {
                this.x = x;
                this.y = y;
                this.predkX = predkX;
                this.predkY = predkY;
            }
            
            void move() {
                x += predkX;
                if (x <= 0 || x + ROZMIAR >= szerokosc) {
                    predkX = -predkX;
                }
                
                y += predkY;
                if (y <= 0 || y + ROZMIAR >= wysokosc) {
                    predkY = -predkY;
                }                
            }            
        }
    }
}
