package helion.rozdzial4;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ElementMIDlet extends MIDlet 
        implements CommandListener, ItemStateListener {

    // Obiekt Display MIDletu
    private Display ekran;
        
    // Znacznik oznaczajacy pierwsze wywolanie startApp
    protected boolean uruchomiony;
    
    // Polecenie Exit
    private Command polecenieExit;
    
    // Polecenie powrot do listy przykladow
    private Command poleceniePowrot;
    
    // Lista przykladow 
    private List listaPrzykl;
    
    // Ekrany wykorzystywane do demonstrowania roznych obiektow Item
    private Screen[] ekrany;
    
    // Nazwy przykladow wykorzystywane do wypelnienia listy.
    private String[] przyklady = {
        "StringItem", "TextField", "DateField",
        "ImageItem", "Gauge", "ChoiceGroup",
        "List", "Alert", "Sound"
    };
    
    // Lista typow ostrzezen
    private AlertType[] typyOstrzezen = new AlertType[] {
        AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR,
        AlertType.INFO, AlertType.WARNING, null
    };
    
    private String[] nazwyTypowOstrzezen = new String[] {
        "ALARM", "POTWIERDZENIE", "BLAD", "INFORMACJA", "OSTRZEZENIE", "Brak"
    };

    protected void startApp() {
        if (!uruchomiony) {
            uruchomiony = true;
            ekran = Display.getDisplay(this);
            
            // Tworzenie wspolnych polecen
            tworzPolecenia();
            
            // Tworzenie ekranow
            tworzEkrany();
            
            // Tworzenie listy przykladow
            tworzListe();
            
            // Rozpoczecie od listy
            ekran.setCurrent(listaPrzykl);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == listaPrzykl) {
            // Wybrano nowy przyklad
            int index = listaPrzykl.getSelectedIndex();
            ekran.setCurrent(ekrany[index]);
        } else if (c == polecenieExit) {
            // Koniec. Nie ma potrzeby wywolywania metody destroyApp
            // poniewaz jest pusta.
            notifyDestroyed();
        } else if (c == poleceniePowrot) {
            // Powrot do glownej listy wyboru
            ekran.setCurrent(listaPrzykl);
        } else if (c == List.SELECT_COMMAND) {
            // Wybor dokonany przez NIEJAWNA LISTE
            handleChoiceSelection((Choice)d);
        }
    }
    
    public void itemStateChanged(Item item) {        
        if (item instanceof TextField) {
            System.out.println("Text field content: <" +
                            ((TextField)item).getString() + ">");
        } else if (item instanceof DateField) {
            DateField df = (DateField)item;
            Date date = df.getDate();
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                System.out.println("Date field content set to " + date);
            } else {
                System.out.println("Date field content set to null");
            }
        } else if (item instanceof Gauge) {
            int value = ((Gauge)item).getValue();
            System.out.println("Gauge value set to " + value);
        } else if (item instanceof ChoiceGroup) {
            handleChoiceSelection((Choice)item);
        } else {
            System.out.println("Item state changed in " + item);
        }
    }    
    
    private void tworzPolecenia() {
        polecenieExit = new Command("Exit", Command.EXIT, 0);
        poleceniePowrot = new Command("Back", Command.BACK, 1);
    }
    
    private void tworzListe() {
        listaPrzykl = new List("Select Example", List.IMPLICIT);
        for (int i = 0; i < przyklady.length; i++) {
            listaPrzykl.append(przyklady[i], null);
        } 
        listaPrzykl.setCommandListener(this);
    }
    
    private void tworzEkrany() {
        ekrany = new Screen[przyklady.length];
        ekrany[0] = createStringsForm();
        ekrany[1] = createTextFieldForm();
        ekrany[2] = createDateFieldForm();
        ekrany[3] = createImageItemForm();
        ekrany[4] = createGaugeForm();
        ekrany[5] = createChoiceGroupForm();
        ekrany[6] = createListExample();
        ekrany[7] = createAlertForm();
        ekrany[8] = createSoundsForm();
    }

    private void addCommands(Displayable d) {
        d.addCommand(polecenieExit);
        d.addCommand(poleceniePowrot);
        d.setCommandListener(this);
        if (d instanceof Form) {
            ((Form)d).setItemStateListener(this);
        }
    }
    
    // Example for StringItem
    private Form createStringsForm() {
        Form form = new Form("StringItem");
        
        form.append(new StringItem("State ", "OK"));
        form.append(new StringItem(null, "No label\n"));
        form.append(new StringItem(null, "Line\nbreak"));
        form.append(new StringItem("Label", "Text."));
        form.append(new StringItem("Label2 ", "Text2."));
        
        addCommands(form);
        return form;
    }
    
    // Example for TextField
    private Form createTextFieldForm() {
        Form form = new Form("TextField");
        
        form.append(new TextField("Any", null, 8, TextField.ANY));
        form.append(new TextField("Phone", "1234567890", 10, TextField.PHONENUMBER));
        form.append(new TextField("Number", "12345", 8, TextField.NUMERIC));
        form.append(new TextField("Password", null, 8, TextField.PASSWORD | TextField.NUMERIC));
        
        addCommands(form);
        return form;
    }
    
    // Example for DateField
    private Form createDateFieldForm() {
        Form form = new Form("DateField");
        
        // Get Calendar for the epoch date and time
        Calendar baseCal = Calendar.getInstance();
        Date baseDate = new Date(0);
        baseCal.setTime(baseDate);
        
        // Get Calendar for now and use the epoch
        // values to reset the date to the epoch.
        Calendar cal = Calendar.getInstance();
        Date now = new Date();       
        cal.setTime(now);
        cal.set(Calendar.YEAR, baseCal.get(Calendar.YEAR));
        cal.set(Calendar.MONTH, baseCal.get(Calendar.MONTH));
        cal.set(Calendar.DATE, baseCal.get(Calendar.DATE));
        
        DateField timeOnly = new DateField("Time", DateField.TIME);
        DateField dateOnly = new DateField("Date", DateField.DATE);
        DateField both = new DateField("Both", DateField.DATE_TIME);
        
        timeOnly.setDate(cal.getTime());
        dateOnly.setDate(now);
        both.setDate(now);
        
        form.append(timeOnly);
        form.append(dateOnly);
        form.append(both);
       
        addCommands(form);
        return form;
    }
    
    // Example for ImageItem
    private Form createImageItemForm() {
        Form form = new Form("ImageItem");
        
        try {
            Image red = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image blue = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");

            // ImageItems with labels
            // (1)
            form.append(new ImageItem("Center", red, ImageItem.LAYOUT_CENTER, null));
            
            // (2)
            form.append(new ImageItem("Left", red, ImageItem.LAYOUT_LEFT, null));
            
            // (3)
            form.append(new ImageItem("Right", red, ImageItem.LAYOUT_RIGHT, null));
            
            // (4)
            form.append(new ImageItem("Default", red, ImageItem.LAYOUT_DEFAULT, null));
            
            // ImageItems with no labels
            // (5)
            form.append(new ImageItem(null, blue, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_CENTER | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (6)
            form.append(new ImageItem(null, blue, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_DEFAULT | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (7)
            form.append(new ImageItem(null, blue, 
                    ImageItem.LAYOUT_NEWLINE_BEFORE | 
                    ImageItem.LAYOUT_RIGHT | 
                    ImageItem.LAYOUT_NEWLINE_AFTER, null));
            
            // (8)
            form.append(new ImageItem(null, blue, ImageItem.LAYOUT_DEFAULT, null)); 
            form.append(new ImageItem(null, blue, ImageItem.LAYOUT_DEFAULT, null)); 
        } catch (IOException ex) {
            form.append("Failed to load images");
        }
        
        addCommands(form);
        return form;
    }
    
    // Example for Gauge
    private Form createGaugeForm() {
        Form form = new Form("Gauge");
        
        form.append(new Gauge(null, true, 100, 50));
        form.append(new Gauge(null, true, 100, 25));
        form.append(new Gauge(null, false, 100, 50));
        
        addCommands(form);
        return form;
    }
    
    // Przyklad dla ChoiceGroup
    private Form createChoiceGroupForm() {
        Form form = new Form("ChoiceGroup");
        
        try {
            Image red = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image green = Image.createImage("/helion/rozdzial4/zasoby/zielony.png");
            Image blue = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");

            // Exclusive choice group
            String[] strings = new String[] { "Czerwony", "Zielony", "Niebieski" };
            Image[] images = new Image[] { red, green, blue };
            ChoiceGroup exGroup = new ChoiceGroup("Wybierz jedna", ChoiceGroup.EXCLUSIVE,
                                                        strings, images);
            form.append(exGroup);

            // Multiple choice group
            ChoiceGroup multiGroup = new ChoiceGroup("Wybierz kilka", ChoiceGroup.MULTIPLE);
            form.append(multiGroup);
            multiGroup.append("Korzystaj z SSL", null);
            multiGroup.append("Polacz po bledzie", null);
            multiGroup.append("Wlacz sledzenie", null);
        } catch (IOException ex) {
            form.append("Nieudane zaladowanie rysunkow");
        }
        
        addCommands(form);
        return form;
    }
    
    // Example for List
    private Screen createListExample() {
        List list = new List("List", List.IMPLICIT);

        try {
            Image red = Image.createImage("/helion/rozdzial4/zasoby/czerwony.png");
            Image green = Image.createImage("/helion/rozdzial4/zasoby/zielony.png");
            Image blue = Image.createImage("/helion/rozdzial4/zasoby/niebieski.png");
            
            list.append("Red", red);
            list.append("Green", green);
            list.append("Blue", blue);
        } catch (IOException ex) {
            Form form = new Form("Error");
            form.append("Failed to load images");
            return form;
        }
        
        addCommands(list);
        return list;
    }
    
    // Example for Alert
    private Screen createAlertForm() {
        final Form form = new Form("Alert");
        
        // A ChoiceGroup that allows the user to choose between
        // a modal Alert or an Alert with a finite timeout.
        final ChoiceGroup limitGroup = new ChoiceGroup("Timeout", Choice.EXCLUSIVE);
        limitGroup.append("Forever", null);
        limitGroup.append("Bounded 5s", null);
        form.append(limitGroup);
        
        // A Gauge that allows the user to choose the 
        // timeout for the Alert. This appears only if
        // the "Bounded" option is selected.
        final Gauge gauge = new Gauge(null, true, 30, 5);
        
        // A ChoiceGroup that lets the user pick the 
        // type of Alert
        final ChoiceGroup group = createAlertChoiceGroup(true); 
        form.append(group);  
        
        // A Command that is used to display the Alert
        final Command okCommand = new Command("OK", Command.OK, 0);
        
        // Add CommandListener for back/exit commands
        // and the OK command, which is specific to this Form
        form.addCommand(okCommand);
        form.addCommand(polecenieExit);
        form.addCommand(poleceniePowrot);
        form.setCommandListener(new CommandListener() {
            public void commandAction(Command c, Displayable d) {
                if (c == okCommand) {
                    // Create and display the Alert
                    
                    // Get the alert type from the 
                    // second ChoiceGroup
                    int selectedType = group.getSelectedIndex();
                    AlertType alertType = typyOstrzezen[selectedType];
                    String name = nazwyTypowOstrzezen[selectedType];
                    
                    // Get the timeout. This is FOREVER if the
                    // first item in the first ChoiceGroup is
                    // selected. Otherwise it is the value in
                    // the Gauge
                    int timeout = Alert.FOREVER;
                    String timeoutString = "none";
                    if (limitGroup.isSelected(1)) {
                        // "Bounded" selected - get the timeout.
                        timeout = gauge.getValue() * 1000;
                        timeoutString = gauge.getValue() + "s";                        
                    }
                    
                    // Create the Alert and set the timeout
                    Alert alert = new Alert("Alert!",
                        "Alert type: " + name + "\nTimeout = " + timeoutString,
                        null, alertType);
                    alert.setTimeout(timeout);
                    
                    // Display the Alert.
                    ekran.setCurrent(alert);                               
                } else {
                    // Delegate others to the usual commandAction
                    ElementMIDlet.this.commandAction(c, d);
                }                
            }
        });
        
        // Set our own ItemStateListener
        form.setItemStateListener(new ItemStateListener() {
            public void itemStateChanged(Item item) {
                if (item == limitGroup) {
                    if (limitGroup.getSelectedIndex() == 0) {
                        // Get rid of the Gauge
                        form.delete(1);
                    } else {
                        // Add the Gauge
                        form.insert(1, gauge);
                    }
                } else if (item == gauge) {               
                    int value = gauge.getValue();
                    limitGroup.set(1, "Bounded " + value + "s", null);
                }
            }
        });
        return form;
    }
    
        
    // Example for Sounds
    private Screen createSoundsForm() {
        final Form form = new Form("Sounds");
        
        // A ChoiceGroup that lets the user pick the 
        // type of sound
        final ChoiceGroup group = createAlertChoiceGroup(false); 
        form.append(group);  

        addCommands(form);
        
        // Set our own ItemStateListener
        form.setItemStateListener(new ItemStateListener() {
            public void itemStateChanged(Item item) {
                // Get the alert type from the ChoiceGroup
                int selectedType = group.getSelectedIndex();
                AlertType alertType = typyOstrzezen[selectedType];
                boolean result = alertType.playSound(ekran);
                System.out.println("A sound was " + (result ? "" : "not ")
                                    + "played.");
                
            }
        });
        return form;
    }
    
    // Handles the selection for a Choice 
    private void handleChoiceSelection(Choice choice) {
        int count = choice.size();
        boolean[] states = new boolean[count];
        int selCount = choice.getSelectedFlags(states);
        if (selCount > 0) {
            System.out.println("Selected items:");
            for (int i = 0; i < count; i++) {
                if (states[i]) {
                    System.out.println("\t" + choice.getString(i));
                }
            }
        } else {
            System.out.println("No selected items.");
        }
        int selectedIndex = choice.getSelectedIndex();
        System.out.println("Selected index is " + selectedIndex);        
    }
    
    // Creates a ChoiceGroup containing a set of Alert types
    private ChoiceGroup createAlertChoiceGroup(boolean includeNone) {
        ChoiceGroup group = new ChoiceGroup("Alert Type", Choice.EXCLUSIVE);
        int count = includeNone ? nazwyTypowOstrzezen.length : nazwyTypowOstrzezen.length - 1;
        for (int i = 0; i < count; i++) {
            group.append(nazwyTypowOstrzezen[i], null);
        }
        return group;
    }
}
