/*
 * Decompiled with CFR 0.152.
 */
package helion.rozdzial4;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ItemMIDlet
extends MIDlet
implements CommandListener,
ItemStateListener {
    private Display display;
    protected boolean started;
    private Command exitCommand;
    private Command backCommand;
    private List examplesList;
    private Screen[] screens;
    private String[] examples = new String[]{"StringItem", "TextField", "DateField", "ImageItem", "Gauge", "ChoiceGroup", "List", "Alert", "Sounds"};
    private AlertType[] alertTypes = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING, null};
    private String[] alertTypeNames = new String[]{"ALARM", "CONFIRMATION", "ERROR", "INFO", "WARNING", "None"};

    protected void startApp() {
        if (!this.started) {
            this.started = true;
            this.display = Display.getDisplay((MIDlet)this);
            this.createCommands();
            this.createScreens();
            this.createList();
            this.display.setCurrent((Displayable)this.examplesList);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.examplesList) {
            int n = this.examplesList.getSelectedIndex();
            this.display.setCurrent((Displayable)this.screens[n]);
        } else if (command == this.exitCommand) {
            this.notifyDestroyed();
        } else if (command == this.backCommand) {
            this.display.setCurrent((Displayable)this.examplesList);
        } else if (command == List.SELECT_COMMAND) {
            this.handleChoiceSelection((Choice)displayable);
        }
    }

    public void itemStateChanged(Item item) {
        if (item instanceof TextField) {
            System.out.println("Text field content: <" + ((TextField)item).getString() + ">");
        } else if (item instanceof DateField) {
            DateField dateField = (DateField)item;
            Date date = dateField.getDate();
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                System.out.println("Date field content set to " + date);
            } else {
                System.out.println("Date field content set to null");
            }
        } else if (item instanceof Gauge) {
            int n = ((Gauge)item).getValue();
            System.out.println("Gauge value set to " + n);
        } else if (item instanceof ChoiceGroup) {
            this.handleChoiceSelection((Choice)item);
        } else {
            System.out.println("Item state changed in " + item);
        }
    }

    private void createCommands() {
        this.exitCommand = new Command("Exit", 7, 0);
        this.backCommand = new Command("Back", 2, 1);
    }

    private void createList() {
        this.examplesList = new List("Select Example", 3);
        int n = 0;
        while (n < this.examples.length) {
            this.examplesList.append(this.examples[n], null);
            ++n;
        }
        this.examplesList.setCommandListener((CommandListener)this);
    }

    private void createScreens() {
        this.screens = new Screen[this.examples.length];
        this.screens[0] = this.createStringsForm();
        this.screens[1] = this.createTextFieldForm();
        this.screens[2] = this.createDateFieldForm();
        this.screens[3] = this.createImageItemForm();
        this.screens[4] = this.createGaugeForm();
        this.screens[5] = this.createChoiceGroupForm();
        this.screens[6] = this.createListExample();
        this.screens[7] = this.createAlertForm();
        this.screens[8] = this.createSoundsForm();
    }

    private void addCommands(Displayable displayable) {
        displayable.addCommand(this.exitCommand);
        displayable.addCommand(this.backCommand);
        displayable.setCommandListener((CommandListener)this);
        if (displayable instanceof Form) {
            ((Form)displayable).setItemStateListener((ItemStateListener)this);
        }
    }

    private Form createStringsForm() {
        Form form = new Form("StringItem");
        form.append((Item)new StringItem("State ", "OK"));
        form.append((Item)new StringItem(null, "No label\n"));
        form.append((Item)new StringItem(null, "Line\nbreak"));
        form.append((Item)new StringItem("Label", "Text."));
        form.append((Item)new StringItem("Label2 ", "Text2."));
        this.addCommands((Displayable)form);
        return form;
    }

    private Form createTextFieldForm() {
        Form form = new Form("TextField");
        form.append((Item)new TextField("Any", null, 8, 0));
        form.append((Item)new TextField("Phone", "1234567890", 10, 3));
        form.append((Item)new TextField("Number", "12345", 8, 2));
        form.append((Item)new TextField("Password", null, 8, 65538));
        this.addCommands((Displayable)form);
        return form;
    }

    private Form createDateFieldForm() {
        Form form = new Form("DateField");
        Calendar calendar = Calendar.getInstance();
        Date date = new Date(0L);
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        Date date2 = new Date();
        calendar2.setTime(date2);
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        DateField dateField = new DateField("Time", 2);
        DateField dateField2 = new DateField("Date", 1);
        DateField dateField3 = new DateField("Both", 3);
        dateField.setDate(calendar2.getTime());
        dateField2.setDate(date2);
        dateField3.setDate(date2);
        form.append((Item)dateField);
        form.append((Item)dateField2);
        form.append((Item)dateField3);
        this.addCommands((Displayable)form);
        return form;
    }

    private Form createImageItemForm() {
        Form form = new Form("ImageItem");
        try {
            Image image = Image.createImage((String)"/ora/ch4/resources/red.png");
            Image image2 = Image.createImage((String)"/ora/ch4/resources/blue.png");
            form.append((Item)new ImageItem("Center", image, 3, null));
            form.append((Item)new ImageItem("Left", image, 1, null));
            form.append((Item)new ImageItem("Right", image, 2, null));
            form.append((Item)new ImageItem("Default", image, 0, null));
            form.append((Item)new ImageItem(null, image2, 771, null));
            form.append((Item)new ImageItem(null, image2, 768, null));
            form.append((Item)new ImageItem(null, image2, 770, null));
            form.append((Item)new ImageItem(null, image2, 0, null));
            form.append((Item)new ImageItem(null, image2, 0, null));
        }
        catch (IOException iOException) {
            form.append("Failed to load images");
        }
        this.addCommands((Displayable)form);
        return form;
    }

    private Form createGaugeForm() {
        Form form = new Form("Gauge");
        form.append((Item)new Gauge(null, true, 100, 50));
        form.append((Item)new Gauge(null, true, 100, 25));
        form.append((Item)new Gauge(null, false, 100, 50));
        this.addCommands((Displayable)form);
        return form;
    }

    private Form createChoiceGroupForm() {
        Form form = new Form("ChoiceGroup");
        try {
            Image image = Image.createImage((String)"/ora/ch4/resources/red.png");
            Image image2 = Image.createImage((String)"/ora/ch4/resources/green.png");
            Image image3 = Image.createImage((String)"/ora/ch4/resources/blue.png");
            String[] stringArray = new String[]{"Red", "Green", "Blue"};
            Image[] imageArray = new Image[]{image, image2, image3};
            ChoiceGroup choiceGroup = new ChoiceGroup("Choose one", 1, stringArray, imageArray);
            form.append((Item)choiceGroup);
            ChoiceGroup choiceGroup2 = new ChoiceGroup("Choose any", 2);
            form.append((Item)choiceGroup2);
            choiceGroup2.append("Use SSL", null);
            choiceGroup2.append("Reconnect on failure", null);
            choiceGroup2.append("Enable tracing", null);
        }
        catch (IOException iOException) {
            form.append("Failed to load images");
        }
        this.addCommands((Displayable)form);
        return form;
    }

    private Screen createListExample() {
        List list = new List("List", 3);
        try {
            Image image = Image.createImage((String)"/ora/ch4/resources/red.png");
            Image image2 = Image.createImage((String)"/ora/ch4/resources/green.png");
            Image image3 = Image.createImage((String)"/ora/ch4/resources/blue.png");
            list.append("Red", image);
            list.append("Green", image2);
            list.append("Blue", image3);
        }
        catch (IOException iOException) {
            Form form = new Form("Error");
            form.append("Failed to load images");
            return form;
        }
        this.addCommands((Displayable)list);
        return list;
    }

    private Screen createAlertForm() {
        final Form form = new Form("Alert");
        final ChoiceGroup choiceGroup = new ChoiceGroup("Timeout", 1);
        choiceGroup.append("Forever", null);
        choiceGroup.append("Bounded 5s", null);
        form.append((Item)choiceGroup);
        final Gauge gauge = new Gauge(null, true, 30, 5);
        final ChoiceGroup choiceGroup2 = this.createAlertChoiceGroup(true);
        form.append((Item)choiceGroup2);
        final Command command = new Command("OK", 4, 0);
        form.addCommand(command);
        form.addCommand(this.exitCommand);
        form.addCommand(this.backCommand);
        form.setCommandListener(new CommandListener(){

            public void commandAction(Command command2, Displayable displayable) {
                if (command2 == command) {
                    int n = choiceGroup2.getSelectedIndex();
                    AlertType alertType = ItemMIDlet.this.alertTypes[n];
                    String string = ItemMIDlet.this.alertTypeNames[n];
                    int n2 = -2;
                    String string2 = "none";
                    if (choiceGroup.isSelected(1)) {
                        n2 = gauge.getValue() * 1000;
                        string2 = gauge.getValue() + "s";
                    }
                    Alert alert = new Alert("Alert!", "Alert type: " + string + "\nTimeout = " + string2, null, alertType);
                    alert.setTimeout(n2);
                    ItemMIDlet.this.display.setCurrent((Displayable)alert);
                } else {
                    ItemMIDlet.this.commandAction(command2, displayable);
                }
            }
        });
        form.setItemStateListener(new ItemStateListener(){

            public void itemStateChanged(Item item) {
                if (item == choiceGroup) {
                    if (choiceGroup.getSelectedIndex() == 0) {
                        form.delete(1);
                    } else {
                        form.insert(1, (Item)gauge);
                    }
                } else if (item == gauge) {
                    int n = gauge.getValue();
                    choiceGroup.set(1, "Bounded " + n + "s", null);
                }
            }
        });
        return form;
    }

    private Screen createSoundsForm() {
        Form form = new Form("Sounds");
        final ChoiceGroup choiceGroup = this.createAlertChoiceGroup(false);
        form.append((Item)choiceGroup);
        this.addCommands((Displayable)form);
        form.setItemStateListener(new ItemStateListener(){

            public void itemStateChanged(Item item) {
                int n = choiceGroup.getSelectedIndex();
                AlertType alertType = ItemMIDlet.this.alertTypes[n];
                boolean bl = alertType.playSound(ItemMIDlet.this.display);
                System.out.println("A sound was " + (bl ? "" : "not ") + "played.");
            }
        });
        return form;
    }

    private void handleChoiceSelection(Choice choice) {
        int n;
        int n2 = choice.size();
        boolean[] blArray = new boolean[n2];
        int n3 = choice.getSelectedFlags(blArray);
        if (n3 > 0) {
            System.out.println("Selected items:");
            n = 0;
            while (n < n2) {
                if (blArray[n]) {
                    System.out.println("\t" + choice.getString(n));
                }
                ++n;
            }
        } else {
            System.out.println("No selected items.");
        }
        n = choice.getSelectedIndex();
        System.out.println("Selected index is " + n);
    }

    private ChoiceGroup createAlertChoiceGroup(boolean bl) {
        ChoiceGroup choiceGroup = new ChoiceGroup("Alert Type", 1);
        int n = bl ? this.alertTypeNames.length : this.alertTypeNames.length - 1;
        int n2 = 0;
        while (n2 < n) {
            choiceGroup.append(this.alertTypeNames[n2], null);
            ++n2;
        }
        return choiceGroup;
    }
}

