// Listing 7.6: LightRowSet.java

package com.oreilly.patterns.chapter7;

import java.sql.*;
import java.util.*;

/**
 * Dostarcza uproszczonych obiektw obudowujcych zbir rekordw. 
 * Stara si zachowa typy danych.
 */

public class LightRowSet implements java.io.Serializable {
    ArrayList rows = null;
    int rowCount = 0;
    int colCount = 0;
    String[] colNames = null;

    public LightRowSet(ResultSet rs) throws SQLException {
        rows = new ArrayList();

        if (rs == null) {
            throw new SQLException("Nie dostarczono obiektu ResultSet");
        }

        ResultSetMetaData rsmd = rs.getMetaData();
        colCount = rsmd.getColumnCount();
        colNames = new String[colCount];

        for (int i = 0; i < colCount; i++) {
            colNames[i] = rsmd.getColumnName(i + 1);
        }

        while (rs.next()) {
            Object[] row = new Object[colCount];

            for (int i = 0; i < colCount; i++)
                row[i] = rs.getObject(i + 1);

            rows.add(row);
        }

        rs.close();
    }

    /** Zwraca nazwy kolumn */
    public String[] getColumnNames() {
        return colNames;
    }

    /**
     * Zwraca iterator wszystkich rekordw
     */
    public Iterator getRows() {
        return rows.iterator();
    }

    /**
     * Zwraca wybrany rekord, z zakresu 1..n. Zwraca warto null 
     * jeli rekord nie zosta znaleziony.
     */
    public Object[] getRow(int index) {
      try {
        return (Object[]) rows.get(index - 1);
      } catch (ArrayIndexOutOfBoundsException aioobe) {
        return null;
      }
    }

    public int getRowCount() {
        return rows.size();
    }
}
